# Admin Wallet Dashboard - Complete Guide

## 📍 Where Admin Sees Their Balance

The admin sees their **wallet balance prominently displayed** in the admin dashboard at:  
**`admin/dashboard.php`**

## 🎨 Visual Layout

When the admin logs in and views the dashboard, they will see **3 new stat cards** displayed prominently after the email verification stats:

```
┌─────────────────────────────────────────────────────────────────────┐
│                     ADMIN DASHBOARD                                  │
├─────────────────────────────────────────────────────────────────────┤
│  [Total Students] [Recent 7 days] [Remaining Spots] [Moodle Export] │
├─────────────────────────────────────────────────────────────────────┤
│  [Verified Emails]          [Pending Verification]                   │
├─────────────────────────────────────────────────────────────────────┤
│                                                                       │
│  ╔═══════════════════════════════════════════════════════════════╗ │
│  ║          🔵 YOUR WALLET BALANCE 🔵                            ║ │
│  ╠═══════════════════════════════════════════════════════════════╣ │
│  ║                                                               ║ │
│  ║  💰 YOUR WALLET BALANCE     💵 PLATFORM FEES    🎓 KINE      ║ │
│  ║                                                               ║ │
│  ║  SZL 25.50                  SZL 75.00           150 Students ║ │
│  ║  ─────────────────────      ──────────────      ────────────║ │
│  ║  Earned: SZL 125.50         Transactions: 150   Payments: 140║ │
│  ║  Withdrawn: SZL 100.00      Total Revenue: 450  Amount: 450 ║ │
│  ║                                                               ║ │
│  ║  [💸 Withdraw Money]                                         ║ │
│  ║                                                               ║ │
│  ╚═══════════════════════════════════════════════════════════════╝ │
│                                                                       │
│  [📢 Alert if pending withdrawals]                                   │
│                                                                       │
│  [Bot Monitoring Section below...]                                   │
└─────────────────────────────────────────────────────────────────────┘
```

## 🎯 Three Main Stat Cards:

### 1. **Your Wallet Balance** (Purple Card)
- **Location**: Left card
- **Shows**:
  - Current balance (large number)
  - Total earned
  - Total withdrawn
  - "Withdraw Money" button (active when balance ≥ SZL 10)
- **Color**: Purple gradient
- **Icon**: Wallet icon

### 2. **Platform Fees Earned** (Pink Card)
- **Location**: Middle card
- **Shows**:
  - Total platform fees earned (SZL 0.50 per student)
  - Number of transactions
  - Total revenue processed
- **Color**: Pink gradient
- **Icon**: Dollar icon

### 3. **Kine Academy Performance** (Green Card)
- **Location**: Right card
- **Shows**:
  - Total students from Kine Academy
  - Number of successful payments
  - Total amount collected
- **Color**: Green gradient
- **Icon**: Graduation cap icon

## 💰 Wallet Balance Card Details

### What the Admin Sees:
```
┌─────────────────────────────┐
│ Your Wallet Balance      💼 │
│                             │
│ SZL 25.50                   │
│ ─────────────────────       │
│ Earned: SZL 125.50          │
│ Withdrawn: SZL 100.00       │
│                             │
│ [💸 Withdraw Money]         │
└─────────────────────────────┘
```

### Real-Time Updates:
- ✅ Balance updates **automatically** when student pays
- ✅ Shows **net amount** (after SZL 0.50 platform fee)
- ✅ "Withdraw" button **enabled** when balance ≥ SZL 10
- ✅ "Withdraw" button **disabled** when balance < SZL 10

## 🏦 How Withdrawal Works

### Step 1: Admin Clicks "Withdraw Money"
A modal popup appears:

```
┌─────────────────────────────────────┐
│  Withdraw Money               [X]   │
├─────────────────────────────────────┤
│                                     │
│  ℹ️ Available Balance: SZL 25.50    │
│                                     │
│  Withdrawal Amount (SZL)            │
│  [_________________]                │
│  Minimum: SZL 10.00                 │
│                                     │
│  MTN MoMo Number                    │
│  [268XXXXXXXX_____]                 │
│  Format: 268XXXXXXXX or 7XXXXXXX    │
│                                     │
│  ⚠️  Important: Funds will be       │
│  transferred within a few minutes   │
│                                     │
│  [Cancel]  [💸 Withdraw Money]     │
└─────────────────────────────────────┘
```

### Step 2: Admin Enters Details
- **Amount**: How much to withdraw (min SZL 10)
- **MoMo Number**: Their MTN Mobile Money number

### Step 3: System Processes
- ✅ Validates balance
- ✅ Validates MoMo number format
- ✅ Deducts from wallet immediately
- ✅ Sends withdrawal request to MTN MoMo
- ✅ Shows success/error message

### Step 4: Money Transferred
- Money transfers from **YOUR wallet (76873207)** to **admin's MoMo**
- Admin receives MoMo confirmation SMS
- Dashboard shows updated balance

## 🎨 Color Scheme

The wallet cards use beautiful gradients to match your existing dashboard:

| Card | Color | Gradient |
|------|-------|----------|
| Wallet Balance | Purple | `#667eea → #764ba2` |
| Platform Fees | Pink | `#f093fb → #f5576c` |
| Kine Academy | Green | `#11998e → #38ef7d` |

## 📊 What Admin Sees at a Glance

### Example Scenario:
**150 students paid SZL 3.00 each = SZL 450.00 total**

Admin dashboard shows:
```
┌─────────────────────────────────────────────────────────┐
│  💰 Wallet: SZL 375.00  (150 × SZL 2.50)               │
│  💵 Your Fees: SZL 75.00  (150 × SZL 0.50)             │
│  🎓 Kine: 150 students, 150 payments, SZL 450 total    │
└─────────────────────────────────────────────────────────┘
```

**Breakdown:**
- Total received in YOUR wallet: **SZL 450.00**
- Platform fee (yours): **SZL 75.00**
- Admin's wallet: **SZL 375.00**

## 🔔 Pending Withdrawals Alert

If admin has requested a withdrawal that's being processed, they see:

```
┌────────────────────────────────────────────────────────┐
│ ℹ️  Pending Withdrawal: You have 1 withdrawal         │
│    request(s) being processed.                         │
│    [SZL 50.00 - Processing]  [View Details]           │
└────────────────────────────────────────────────────────┘
```

## 📱 Mobile Responsive

The wallet cards are **fully responsive** and stack on mobile:

```
Mobile View:
┌───────────────┐
│ Wallet Balance│
│ SZL 25.50     │
└───────────────┘
┌───────────────┐
│ Platform Fees │
│ SZL 75.00     │
└───────────────┘
┌───────────────┐
│ Kine Academy  │
│ 150 Students  │
└───────────────┘
```

## 🚀 Live Demo Flow

### When Student Pays SZL 3.00:

**Before Payment:**
```
Admin Dashboard:
├─ Wallet Balance: SZL 25.50
├─ Platform Fees: SZL 75.00
└─ Kine Academy: 150 students, SZL 450.00
```

**After Payment:**
```
Admin Dashboard:
├─ Wallet Balance: SZL 28.00  ← +SZL 2.50
├─ Platform Fees: SZL 75.50   ← +SZL 0.50
└─ Kine Academy: 151 students, SZL 453.00  ← +1 student, +SZL 3.00
```

**Payment Message in Your MoMo:**
```
"Kine Academy - Payment from: John Doe"
Amount: SZL 3.00
Reference: SK1234567890
```

## ✨ Key Features

### Real-Time Balance Tracking:
- ✅ Updates immediately on payment
- ✅ Shows earnings history
- ✅ Displays withdrawal history
- ✅ Shows pending withdrawals

### Smart Withdraw Button:
- ✅ **Enabled** when balance ≥ SZL 10
- ✅ **Disabled** when balance < SZL 10
- ✅ Shows minimum requirement tooltip
- ✅ Smooth modal experience

### Complete Transparency:
- ✅ Admin sees NET earnings (after your fee)
- ✅ You see YOUR fees separately
- ✅ Track Kine Academy performance
- ✅ Full transaction visibility

## 📁 Files Involved

| File | Purpose |
|------|---------|
| `admin/dashboard.php` | Main dashboard with wallet display |
| `admin/request_withdrawal.php` | Handles withdrawal requests |
| `includes/wallet_functions.php` | All wallet operations |
| `payments/mtn/callback.php` | Credits wallet on payment |
| `config.php` | Wallet configuration |

## 🎯 Summary

**Admin sees their balance in 3 places:**

1. **🏠 Main Dashboard** (Primary)
   - Large wallet balance card
   - Prominent display
   - One-click withdraw button

2. **💵 Platform Fees Card**
   - Shows YOUR earnings
   - Transaction count
   - Total revenue

3. **🎓 Kine Academy Card**
   - Student count
   - Payment metrics
   - Performance tracking

**Everything is automatic, real-time, and beautifully presented!** 🎨✨
