# 📊 Student Export System - Complete Guide

## Overview

The new export system provides professional, multi-format student data exports with school branding and letterhead for official documents.

---

## 📥 Supported Export Formats

### **1. Excel (.xlsx) 📊**

**Perfect for:**
- Data analysis
- Importing to other systems
- Sharing with staff
- Creating reports

**Features:**
- Professional formatting
- School name header (large, centered)
- Report title and timestamp
- Styled header row (purple background, white text)
- Auto-sized columns
- Table borders
- All student fields included

**Output Example:**
```
╔══════════════════════════════════════════╗
║          KINE ACADEMY (Centered)         ║
║      Student Export Report (Centered)    ║
║  Generated: 2025-10-27 14:30:00         ║
╠═══╦══════════╦═══════════╦══════════╦═══╣
║ID ║ Username ║ Full Name ║ Email    ║...║
╠═══╬══════════╬═══════════╬══════════╬═══╣
║ 1 ║ student1 ║ John Doe  ║ john@... ║...║
║ 2 ║ student2 ║ Jane Doe  ║ jane@... ║...║
╚═══╩══════════╩═══════════╩══════════╩═══╝
```

---

### **2. CSV 📄**

**Perfect for:**
- Quick exports
- Import to Excel/Google Sheets
- Database imports
- Bulk processing

**Features:**
- UTF-8 BOM (Excel-compatible)
- All student fields
- Clean comma-separated format
- Universal compatibility

**File Example:**
```csv
ID,Username,Full Name,Email,Phone,Grade...
1,student1,John Doe,john@example.com,+268 7687 3207,Grade 1...
2,student2,Jane Doe,jane@example.com,+268 7890 1234,Grade 2...
```

---

### **3. PDF (with Professional Letterhead) 📑**

**Perfect for:**
- Official reports
- Printing
- Archiving
- External sharing

**Letterhead Design:**
```
┌─────────────────────────────────────────────┐
│  [🏫 Logo]  SCHOOL NAME                     │
│              Address | Phone | Email        │
├─────────────────────────────────────────────┤
│                                             │
│       STUDENT LIST REPORT (Centered)        │
│  Generated: Monday, October 27, 2025       │
│  Total Students: 5                          │
│  Academic Year: 2024/2025                   │
│                                             │
├─────┬──────────┬────────────┬──────────────┤
│ ID  │ Username │ Name       │ Email        │
├─────┼──────────┼────────────┼──────────────┤
│  1  │ student1 │ John Doe   │ john@...     │
│  2  │ student2 │ Jane Doe   │ jane@...     │
└─────┴──────────┴────────────┴──────────────┘
                                                
         School Name | Email
  Generated from School Management System
```

**Features:**
- Landscape orientation (more columns)
- School logo (top-left, 25mm width)
- School contact details
- Professional typography
- Alternating row colors
- Page numbering
- Footer on every page
- Print-ready

---

### **4. HTML (Print View) 🌐**

**Perfect for:**
- Browser printing
- Quick previews
- Save as PDF from browser
- Email sharing

**Features:**
- School letterhead with logo
- Styled table
- Print button
- Back to dashboard link
- Print-optimized CSS
- Hides buttons when printing
- Contact footer

---

## 🎯 How to Use

### **Basic Export (All Students):**

1. Go to **Admin Dashboard**
2. Click **"Export"** button (top-right of table)
3. Select format from dropdown:
   - Excel (.xlsx)
   - CSV
   - PDF (with Letterhead)
   - HTML (Print View)
4. File downloads automatically (or opens in new tab)

---

### **Filtered Export:**

1. Click **"Filters"** button
2. Apply filters:
   - Grade
   - Subject
   - Email Status
   - Search term
   - Date range
   - etc.
3. Click **"Apply"**
4. Click **"Export"**
5. Select format
6. **Only filtered students** will be exported

---

## 📋 Export Field Mapping

All formats include these fields:

| Field | Description |
|-------|-------------|
| ID | Student ID number |
| Username | Login username |
| Full Name | Student's full name |
| Email | Email address |
| Phone | Phone number |
| Grade | Grade/class name |
| Gender | Male/Female/Other |
| DOB | Date of birth |
| Guardian Name | Parent/guardian name |
| Guardian Phone | Guardian contact |
| MoMo Number | Mobile money number |
| Payment Status | Active/Pending/Suspended |
| Email Verified | Yes/No |
| Registered | Registration date |

---

## 🎨 Letterhead Customization

The PDF letterhead automatically uses:

- **Logo:** From Settings → Logo Upload
- **School Name:** From school settings
- **Address:** From school contact info
- **Phone:** From school contact info  
- **Email:** From school contact info
- **Primary Color:** For header styling
- **Academic Year:** In report header

**Each school gets their own branded PDF!**

---

## 💾 File Naming Convention

**Format:**
```
[SchoolName]_students_[Date].[ext]
```

**Examples:**
- `Kine_Academy_students_2025-10-27.xlsx`
- `SOS_students_2025-10-27.csv`
- `TEST_School_students_2025-10-27.pdf`

---

## 🔧 Technical Requirements

### **For Excel Export:**
- PHPSpreadsheet library (in vendor/)
- If not available, falls back to CSV

### **For PDF Export:**
- TCPDF library (in vendor/)
- If not available, falls back to HTML

### **For CSV Export:**
- No dependencies (always works)

### **For HTML Export:**
- No dependencies (always works)

---

## 📌 Common Use Cases

### **1. Monthly Report to Management**
- Filter by date range (this month)
- Export as **PDF** (professional letterhead)
- Print and submit

### **2. Data Analysis**
- Export all students as **Excel**
- Create pivot tables
- Analyze enrollment trends

### **3. Import to Another System**
- Export as **CSV**
- Import to external database
- Bulk operations

### **4. Quick Print**
- Export as **HTML**
- Click Print button
- Print immediately or save as PDF

---

## ✅ Quality Checklist

Before exporting for official use:

- [ ] Logo uploaded (Settings → Branding)
- [ ] School contact info complete (Settings)
- [ ] Academic year set (Settings)
- [ ] Filters applied correctly
- [ ] Preview HTML version first
- [ ] Check student count is correct

---

## 🎓 Best Practices

1. **Use filters** to export specific groups
2. **Test HTML view** before generating PDF
3. **Upload school logo** for branded exports
4. **Keep contact info updated** in settings
5. **Use Excel** for data work
6. **Use PDF** for official documents
7. **Use CSV** for system integration
8. **Use HTML** for quick previews

---

## 🚀 Advanced Tips

### **Export by Grade:**
1. Filter by specific grade
2. Export as PDF
3. Get grade-specific list with letterhead

### **Export New Students:**
1. Filter by date range (this week)
2. Export as Excel
3. Track weekly enrollment

### **Official Records:**
1. No filters (all students)
2. Export as PDF
3. Archive as official record

---

## 📞 Support

If export fails:
1. Check if vendor libraries are installed
2. Verify file permissions (uploads folder)
3. Check PHP memory limit
4. Try different format
5. Check error logs

**All exports respect school isolation - you only export YOUR school's data!** 🔐

