# 📁 **FILES TO UPLOAD TO CPANEL**
## Exact File List for Skolo-Kine Deployment

**Status**: Production Ready System  
**Purpose**: Deploy existing system to cPanel hosting

---

## 🎯 **CORE FILES TO UPLOAD**

### **📄 Root Directory Files**
Upload these files to your cPanel's `public_html` directory:

```
📁 Upload to public_html/:
├── index.php                          # Main registration page
├── register.php                       # Registration handler
├── success.php                        # Success page
├── verify-email.php                   # Email verification
├── reset-password.php                 # Password reset
├── config.php                         # Configuration file
├── composer.json                      # PHP dependencies
├── composer.lock                      # Dependency lock file
├── requirements.txt                   # Python dependencies
├── .htaccess                          # Apache configuration
├── robots.txt                         # SEO configuration
└── sitemap.xml                        # Site map
```

### **📁 Directory Structure to Create**
Create these directories in `public_html`:

```
📁 Create Directories:
├── includes/
├── admin/
├── payments/
│   └── mtn/
├── bot/
├── database/
├── cron/
├── assets/
│   ├── css/
│   ├── js/
│   └── images/
├── uploads/
├── exports/
├── logs/
├── backups/
└── vendor/
```

---

## 📂 **DETAILED FILE UPLOAD LIST**

### **1. INCLUDES DIRECTORY**
Upload to `public_html/includes/`:

```
📁 includes/:
├── functions.php                      # Core functions
├── email_functions.php                # Email system
├── email_templates.php                # Email templates
├── security_headers.php               # Security features
└── monitoring_system.php              # Monitoring system
```

### **2. ADMIN DIRECTORY**
Upload to `public_html/admin/`:

```
📁 admin/:
├── login.php                          # Admin login
├── dashboard.php                      # Admin dashboard
├── create.php                         # Create student
├── edit.php                           # Edit student
├── delete.php                         # Delete student
├── payments.php                       # Payment management
├── backup_management.php              # Backup management
└── monitoring_dashboard.php           # System monitoring
```

### **3. PAYMENT SYSTEM**
Upload to `public_html/payments/mtn/`:

```
📁 payments/mtn/:
├── request.php                        # Payment request
├── status.php                         # Payment status
└── callback.php                       # Payment callback
```

### **4. PYTHON BOT FILES**
Upload to `public_html/bot/`:

```
📁 bot/:
├── moodle_sync_bot.py                 # Main sync bot
├── enhanced_moodle_sync_bot.py       # Enhanced bot
├── bot_api.py                         # Bot API
├── database.py                        # Database module
└── requirements.txt                   # Python dependencies
```

### **5. DATABASE FILES**
Upload to `public_html/database/`:

```
📁 database/:
├── schema.sql                         # Main database schema
├── create_email_tables.sql            # Email system tables
├── create_security_tables.sql         # Security tables
├── create_monitoring_tables.sql       # Monitoring tables
└── performance_indexes.sql            # Performance indexes
```

### **6. CRON JOBS**
Upload to `public_html/cron/`:

```
📁 cron/:
├── backup_system.php                  # Backup automation
└── health_check.php                   # Health monitoring
```

### **7. STATIC ASSETS**
Upload to `public_html/assets/`:

```
📁 assets/css/:
├── (any CSS files you have)

📁 assets/js/:
├── (any JavaScript files you have)

📁 assets/images/:
├── (any image files you have)
```

---

## ⚙️ **CONFIGURATION UPDATES NEEDED**

### **1. Update config.php**
Before uploading, update these values in `config.php`:

```php
// Database Configuration (Update with your cPanel database details)
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_cpanel_database_name');
define('DB_USER', 'your_cpanel_db_username');
define('DB_PASS', 'your_cpanel_db_password');

// URL Configuration (Update with your domain)
define('PUBLIC_BASE_URL', 'https://yourdomain.com');
define('MOODLE_URL', 'https://your-moodle-site.com');

// Email Configuration (Update with your cPanel email)
define('SMTP_HOST', 'mail.yourdomain.com');
define('SMTP_USERNAME', 'noreply@yourdomain.com');
define('SMTP_PASSWORD', 'your_email_password');
define('SMTP_FROM_EMAIL', 'noreply@yourdomain.com');
define('SMTP_FROM_NAME', 'Skolo-Kine Learning Platform');
```

### **2. Update .htaccess**
Ensure your `.htaccess` file includes:

```apache
# Security Headers
<IfModule mod_headers.c>
    Header always set X-Content-Type-Options nosniff
    Header always set X-Frame-Options DENY
    Header always set X-XSS-Protection "1; mode=block"
</IfModule>

# Hide sensitive files
<Files "config.php">
    Order Allow,Deny
    Deny from all
</Files>

# Block access to sensitive directories
RedirectMatch 403 ^/database/
RedirectMatch 403 ^/logs/
RedirectMatch 403 ^/backups/
```

---

## 🗄️ **DATABASE SETUP REQUIRED**

### **1. Create Database in cPanel**
1. Go to cPanel → MySQL Databases
2. Create database: `skolo_kine`
3. Create user with full privileges
4. Import these SQL files in order:
   - `database/schema.sql`
   - `database/create_email_tables.sql`
   - `database/create_security_tables.sql`
   - `database/create_monitoring_tables.sql`
   - `database/performance_indexes.sql`

---

## 📋 **UPLOAD CHECKLIST**

### **Phase 1: Core Files**
- [ ] Upload root directory files (index.php, register.php, etc.)
- [ ] Create directory structure
- [ ] Upload includes/ directory
- [ ] Upload admin/ directory

### **Phase 2: System Files**
- [ ] Upload payments/mtn/ directory
- [ ] Upload bot/ directory
- [ ] Upload database/ directory
- [ ] Upload cron/ directory

### **Phase 3: Configuration**
- [ ] Update config.php with cPanel details
- [ ] Set file permissions (755 for directories, 644 for files)
- [ ] Create database and import SQL files
- [ ] Test database connection

### **Phase 4: Dependencies**
- [ ] Install Composer dependencies: `composer install`
- [ ] Install Python dependencies: `pip install -r bot/requirements.txt`
- [ ] Set up cron jobs in cPanel

---

## 🔧 **FILE PERMISSIONS TO SET**

### **Directories (755)**
```
uploads/ → 755
exports/ → 755
logs/ → 755
backups/ → 755
vendor/ → 755
bot/ → 755
```

### **Files (644)**
```
All .php files → 644
All .py files → 644
All .sql files → 644
```

### **Security (600)**
```
config.php → 600 (restrict access)
```

---

## 🚀 **QUICK DEPLOYMENT STEPS**

1. **Upload all files** according to the directory structure above
2. **Update config.php** with your cPanel database and email details
3. **Create database** in cPanel and import SQL files
4. **Set file permissions** as specified
5. **Install dependencies** via cPanel terminal
6. **Test the system** by visiting your domain

---

## ✅ **VERIFICATION**

After upload, test these URLs:
- `https://yourdomain.com` (Main registration page)
- `https://yourdomain.com/admin/login.php` (Admin login)
- `https://yourdomain.com/admin/backup_management.php` (Backup system)
- `https://yourdomain.com/admin/monitoring_dashboard.php` (Monitoring)

---

## 📝 **SUMMARY**

**Total Files to Upload**: ~50 files  
**Directories to Create**: 12 directories  
**Database Files**: 5 SQL files to import  
**Configuration**: 1 config.php to update  
**Dependencies**: Composer + Python packages  

**Your existing system is ready for cPanel deployment with all enterprise features intact!** 🎯✨
