# 🔧 Fix: Foreign Key Constraint Error

## ❌ **The Error**

```
#1451 - Cannot delete or update a parent row: a foreign key constraint fails
```

## 🔍 **What Happened**

The migration tries to drop `tenant_files` table, but other tables have foreign keys pointing to it:
- `tenant_file_access_log` → references `tenant_files(id)`
- `tenant_file_versions` → references `tenant_files(id)`

You must drop child tables **before** the parent table.

---

## ✅ **Quick Fix**

Run this in phpMyAdmin **SQL tab**:

```sql
-- Drop in correct order (child tables first)
DROP TABLE IF EXISTS tenant_file_versions;
DROP TABLE IF EXISTS tenant_file_access_log;
DROP TABLE IF EXISTS tenant_files;

-- Now run the migration
-- SOURCE database/migrations/create_tenant_files_table.sql;
```

---

## 📋 **Or Use This Complete Script**

```sql
-- =====================================================
-- SAFE DROP - Correct Order
-- =====================================================

-- Drop views first
DROP VIEW IF EXISTS v_active_tenant_files;
DROP VIEW IF EXISTS v_tenant_file_stats;

-- Drop triggers
DROP TRIGGER IF EXISTS before_tenant_file_access_insert;

-- Drop child tables (with foreign keys)
DROP TABLE IF EXISTS tenant_file_versions;
DROP TABLE IF EXISTS tenant_file_access_log;

-- Drop parent table
DROP TABLE IF EXISTS tenant_files;

-- Drop any backup tables
DROP TABLE IF EXISTS tenant_files_backup_20250130;

SELECT 'All tables dropped successfully' AS status;
```

---

## 🚀 **Then Import Migration**

After running the drop script above:

1. Go to phpMyAdmin **Import** tab
2. Choose: `database/migrations/create_tenant_files_table.sql`
3. Click **Go**
4. ✅ Success!

---

## 📝 **Alternative: Disable Foreign Keys Temporarily**

```sql
-- Disable foreign key checks
SET FOREIGN_KEY_CHECKS = 0;

-- Drop tables (any order)
DROP TABLE IF EXISTS tenant_files;
DROP TABLE IF EXISTS tenant_file_access_log;
DROP TABLE IF EXISTS tenant_file_versions;

-- Re-enable foreign key checks
SET FOREIGN_KEY_CHECKS = 1;

-- Now import migration
```

---

## ✅ **Prevention**

I'll update the migration file to drop in correct order.

