# 📚 How to Configure Subjects for Each Grade

## 🎯 Quick Guide

### **Step 1: Login to Admin Panel**
Visit: `your-site.com/admin/login.php`  
Use your admin credentials

### **Step 2: Click "Configure" in Top Menu**
Look at the top navigation bar:
```
[Dashboard] [Payments] [Restore] [Configure] [Logout]
                                    ↑
                                Click Here!
```

### **Step 3: Configure Subjects**
You'll see cards for each grade:

```
┌─────────────────────────────────────────────────┐
│  Configure Subjects for Grades                  │
├─────────────────────────────────────────────────┤
│                                                  │
│  ┌───────────┐  ┌───────────┐  ┌───────────┐  │
│  │ Grade 7   │  │ Form 1    │  │ Form 2    │  │
│  │           │  │           │  │           │  │
│  │ ☑ Math    │  │ ☑ Math    │  │ ☑ Math    │  │
│  │ ☑ English │  │ ☑ English │  │ ☑ English │  │
│  │ ☑ SiSwati │  │ ☑ SiSwati │  │ ☐ Art     │  │
│  │ ☑ Science │  │ ☑ Science │  │ ☑ Science │  │
│  │ ☑ RE      │  │ ☑ RE      │  │ ☑ RE      │  │
│  │ ☐ Agric   │  │ ☑ Agric   │  │ ☐ Agric   │  │
│  │           │  │           │  │           │  │
│  │ Selected: │  │ Selected: │  │ Selected: │  │
│  │    5      │  │    6      │  │    4      │  │
│  │           │  │           │  │           │  │
│  │ [Save]    │  │ [Save]    │  │ [Save]    │  │
│  └───────────┘  └───────────┘  └───────────┘  │
│                                                  │
│  Quick Actions:                                 │
│  [Select All] [Clear All] [Back to Dashboard]  │
└─────────────────────────────────────────────────┘
```

### **Step 4: Select Subjects for Each Grade**
- ✅ **Check** the subjects you want available
- ✅ **Uncheck** subjects you don't want
- ✅ See **selected count** update in real-time

### **Step 5: Click "Save Changes"**
- Click the blue "Save Changes" button for each grade
- You'll see a success message
- Changes are immediate!

## 💡 Example Configuration

### **Grade 7 (Primary School):**
```
☑ Mathematics
☑ English
☑ SiSwati
☑ Religious Education
☑ Social Studies
☑ Expressive Arts
☐ Agriculture (not offered)
☑ Consumer Science
☑ HPE
☑ Science
☑ ICT
```

### **Form 1 (High School):**
```
☑ Mathematics
☑ English
☑ SiSwati
☑ Religious Education
☑ Social Studies
☐ Expressive Arts (not offered at Form level)
☑ Agriculture
☑ Consumer Science
☑ HPE
☑ Science
☑ ICT
```

## 🎯 Quick Actions

### **Select All Subjects for All Grades:**
Click the green "Select All" button to check all subjects for all grades at once.

### **Clear All Selections:**
Click the yellow "Clear All" button to uncheck everything.

## ✅ What Happens After Configuration

### **When Student Registers:**
1. Student selects "Grade 7"
2. System shows **ONLY** the subjects you configured
3. Student can't see or select unconfigured subjects
4. Registration continues normally

### **Example:**
If you unchecked "Agriculture" for Grade 7:
- Students selecting Grade 7 won't see Agriculture
- They can only choose from the checked subjects
- Prevents incorrect subject selection

## 🔧 Tips & Best Practices

### **1. Configure All Grades:**
Make sure you configure subjects for every grade you offer.

### **2. Update Regularly:**
- Add new subjects when curriculum changes
- Remove subjects no longer offered
- Keep it current

### **3. Test After Changes:**
- Logout of admin
- Try to register as a student
- Verify correct subjects appear

### **4. Bulk Updates:**
Use "Select All" for grades that offer all subjects, then uncheck specific ones.

## 📞 Troubleshooting

### **Problem: Students see all subjects**
**Solution**: You haven't configured that grade yet. Go to Configure page and set subjects.

### **Problem: No subjects showing**
**Solution**: You unchecked all subjects. Check at least one subject and save.

### **Problem: Changes not saving**
**Solution**: Make sure you click "Save Changes" button for that specific grade.

## 🎉 Benefits

- ✅ **Full control** over curriculum
- ✅ **Easy to manage** - visual interface
- ✅ **Prevents errors** - students only see valid options
- ✅ **Flexible** - update anytime
- ✅ **Professional** - organized by grade

**Your subject configuration system is now ready to use!** 📚✨
