# 🧪 Testing Multi-Tenant System on Localhost

## Complete Step-by-Step Testing Guide

---

## ⚡ Quick Test (5 minutes)

### Step 1: Verify Database
```bash
# Open terminal in C:\xampp\htdocs\Multi-Tanent
php tools/test_multi_tenant_isolation.php
```

**Expected Output:**
```
✅ All tests passed! Multi-tenant isolation is working correctly.
```

### Step 2: Login as Admin
1. Open browser: `http://localhost/Multi-Tanent/admin/login.php`
2. Login:
   - Username: `admin`
   - Password: `admin123`
3. You'll be redirected to school selector
4. Select "Kine Academy"
5. You're now in the dashboard!

### Step 3: Create Test School
1. In navigation, click "Super Admin" (if visible)
   - If not visible, skip to Step 4 to enable super admin mode
2. Click "Add New School"
3. Fill in:
   ```
   School Name: Rainbow Test School
   Reference Code: RAINBOW
   Description: Test school for multi-tenant testing
   Admin Email: test@rainbow.com
   Admin Password: Rainbow123!
   ```
4. Click "Create School"
5. Success! School created with username: `rainbow_admin`

### Step 4: Test Isolation
1. Click "Switch School" in navigation
2. Select "Rainbow Test School"
3. Create a test student
4. Switch back to "Kine Academy"
5. Verify: Rainbow student NOT visible
6. Switch to Rainbow: Student IS visible

✅ **System working perfectly!**

---

## 🔧 Detailed Testing Procedures

### Test #1: Enable Super Admin Mode

**Method A: Via Database (Recommended)**
```bash
# Open MySQL
mysql -u root -p

# Select your database
use multi_tenant_skoloi;

# Check current admin
SELECT id, username, academy_reference FROM admins WHERE username = 'admin';

# Make admin a super admin (remove academy_reference)
UPDATE admins SET academy_reference = NULL WHERE username = 'admin';

# Verify
SELECT id, username, academy_reference FROM admins WHERE username = 'admin';
```

**Method B: Via PHP Session**

Create file: `enable_super_admin.php`
```php
<?php
session_start();
$_SESSION['is_super_admin'] = true;
echo "Super admin mode enabled!";
echo "<br><a href='/admin/dashboard.php'>Go to Dashboard</a>";
```

Then visit: `http://localhost/Multi-Tanent/enable_super_admin.php`

---

### Test #2: Create Multiple Schools

**Create School #1: Rainbow Academy**
1. Go to: `http://localhost/Multi-Tanent/super_admin/schools/create.php`
2. Fill in:
   ```
   School Name: Rainbow Academy
   Reference Code: RAINBOW
   Admin Email: admin@rainbow.com
   Admin Password: Rainbow123!
   Description: Progressive learning institution
   ```
3. Click "Create School"
4. Note: Admin username is `rainbow_admin`

**Create School #2: St. Mary's School**
1. Click "Create Another School" or go back to create page
2. Fill in:
   ```
   School Name: St. Mary's High School
   Reference Code: STMARY
   Admin Email: admin@stmarys.com
   Admin Password: StMary123!
   Description: Catholic education center
   ```
3. Click "Create School"
4. Note: Admin username is `stmary_admin`

**Verify:**
- Go to `http://localhost/Multi-Tanent/super_admin/schools/list.php`
- You should see 3 schools: KINE, RAINBOW, STMARY

---

### Test #3: Create Students in Different Schools

**In Kine Academy (KINE):**
1. Switch to Kine Academy
2. Go to Dashboard → Create Student
3. Create student:
   ```
   First Name: Alice
   Last Name: Kine
   Email: alice.kine@test.com
   Grade: Grade 7
   Password: Alice123!
   Subjects: Select a few
   ```
4. Click "Create Student"
5. Note Alice's student ID

**In Rainbow Academy:**
1. Click "Switch School"
2. Select Rainbow Academy
3. Create student:
   ```
   First Name: Bob
   Last Name: Rainbow
   Email: bob.rainbow@test.com
   Grade: Grade 7
   Password: Bob123!
   Subjects: Select a few
   ```
4. Click "Create Student"
5. Note Bob's student ID

**In St. Mary's:**
1. Switch to St. Mary's
2. Create student:
   ```
   First Name: Charlie
   Last Name: Mary
   Email: charlie.mary@test.com
   Grade: Grade 7
   Password: Charlie123!
   Subjects: Select a few
   ```

---

### Test #4: Verify Data Isolation

**Test Cross-School Access:**
1. **While in Kine Academy**, try to access Bob (Rainbow student):
   ```
   http://localhost/Multi-Tanent/admin/edit.php?id=[Bob's ID]
   ```
   
   **Expected:** Access denied or redirected to dashboard

2. **Switch to Rainbow Academy**
3. Try to access Alice (Kine student):
   ```
   http://localhost/Multi-Tanent/admin/edit.php?id=[Alice's ID]
   ```
   
   **Expected:** Access denied or redirected

4. **View Dashboard in Each School:**
   - KINE: Shows only Alice
   - RAINBOW: Shows only Bob
   - STMARY: Shows only Charlie

✅ **Perfect isolation!**

---

### Test #5: Test School Settings

**For Rainbow Academy:**
1. Switch to Rainbow Academy
2. Go to: School Settings (in navigation)
3. Update:
   ```
   School Name: Rainbow Progressive Academy
   School Email: contact@rainbow.com
   School Phone: +268 1111 1111
   Primary Color: #FF6B6B (red)
   Secondary Color: #4ECDC4 (teal)
   Academic Year: 2024/2025
   ```
4. Click "Save Settings"
5. Reload page
6. Verify: School name in header updated

**For St. Mary's:**
1. Switch to St. Mary's
2. Go to School Settings
3. Update with different colors:
   ```
   Primary Color: #DC2626 (dark red)
   Secondary Color: #059669 (green)
   ```
4. Save
5. Verify different colors than Rainbow

✅ **Each school has independent settings!**

---

### Test #6: Test Payment Processing

**Create Payment for Alice (Kine):**
1. Switch to Kine Academy
2. Note Alice's student ID
3. Create a test payment in database:
   ```sql
   INSERT INTO payments 
   (student_id, amount, currency, reference_id, external_id, msisdn, status, payment_method, academy_reference, platform_fee, admin_earnings)
   VALUES 
   ([Alice's ID], 3.00, 'SZL', UUID(), 'TEST001', '76123456', 'SUCCESSFUL', 'MOMO', 'KINE', 0.50, 2.50);
   ```

4. Refresh Kine dashboard
5. Verify payment appears

**Create Payment for Bob (Rainbow):**
1. Create payment:
   ```sql
   INSERT INTO payments 
   (student_id, amount, currency, reference_id, external_id, msisdn, status, payment_method, academy_reference, platform_fee, admin_earnings)
   VALUES 
   ([Bob's ID], 3.00, 'SZL', UUID(), 'TEST002', '76123456', 'SUCCESSFUL', 'MOMO', 'RAINBOW', 0.50, 2.50);
   ```

**Verify Isolation:**
- Kine dashboard: Shows only Alice's payment (E3.00)
- Rainbow dashboard: Shows only Bob's payment (E3.00)
- Super Admin: Shows both (E6.00 total)

✅ **Payment isolation working!**

---

### Test #7: Test Super Admin Features

**Access All Schools Data:**
1. Login as super admin
2. Go to: `http://localhost/Multi-Tanent/super_admin/dashboard.php`
3. Verify you see:
   - Total schools: 3
   - Total students: 3 (Alice, Bob, Charlie)
   - Total revenue: E6.00
   - Platform fees: E1.00

**Manage Schools:**
1. Go to: "Manage Schools"
2. See all 3 schools listed
3. Click "View" on Rainbow
4. See Rainbow's statistics
5. Click "Edit"
6. Change description
7. Save and verify

✅ **Super admin can manage everything!**

---

### Test #8: Test School Admin Limitations

**Login as Rainbow Admin:**
1. Logout from super admin
2. Login with:
   ```
   Username: rainbow_admin
   Password: Rainbow123!
   ```
3. You're automatically in Rainbow Academy
4. Dashboard shows only Bob (Rainbow student)
5. Try to access super admin:
   ```
   http://localhost/Multi-Tanent/super_admin/dashboard.php
   ```
   
   **Expected:** Redirected to regular dashboard (access denied)

✅ **School admins restricted to own school!**

---

### Test #9: Test School Switching

**Switch Between Schools:**
1. Login as super admin
2. Navigate to: "Switch School" in menu
3. You'll see school selector with all schools
4. Click on different schools
5. Verify:
   - Dashboard updates
   - School name in header changes
   - Student list changes
   - Payment data changes

✅ **Smooth school switching!**

---

### Test #10: Test URL Parameter Access

**Method: Query Parameter**
```
http://localhost/Multi-Tanent/select_school.php?school=KINE
http://localhost/Multi-Tanent/select_school.php?school=RAINBOW
http://localhost/Multi-Tanent/select_school.php?school=STMARY
```

Each URL should:
- Set that school as active
- Redirect to dashboard
- Show only that school's data

✅ **Direct school access working!**

---

## 🎯 Complete Testing Workflow

### **30-Minute Complete Test**

```
✓ Step 1: Database Test (1 min)
   php tools/test_multi_tenant_isolation.php

✓ Step 2: Login Test (1 min)
   Login as admin → Select school → Dashboard loads

✓ Step 3: Super Admin Test (2 min)
   Enable super admin → Access super panel → See all schools

✓ Step 4: Create Schools (10 min)
   Create RAINBOW → Create STMARY → Verify both exist

✓ Step 5: Create Students (10 min)
   Student in KINE → Student in RAINBOW → Student in STMARY

✓ Step 6: Isolation Test (5 min)
   Switch schools → Verify data separation → Test URL access

✓ Step 7: Settings Test (5 min)
   Customize each school → Verify independent settings

✓ Step 8: Payment Test (3 min)
   Create test payments → Verify isolation

✓ Step 9: Super Admin Features (3 min)
   View all schools → Manage school → Suspend/activate

✓ Step 10: Security Test (5 min)
   Try cross-school access → Verify blocked
```

**Total: 45 minutes for comprehensive testing**

---

## 🐛 Troubleshooting Common Issues

### Issue: "Super Admin" link not showing in navigation

**Solution 1: Set super admin in database**
```sql
UPDATE admins SET academy_reference = NULL WHERE username = 'admin';
```

**Solution 2: Set in session**
Create `set_super_admin.php`:
```php
<?php
session_start();
require_once 'config.php';
require_once 'includes/functions.php';

if (isAdminLoggedIn()) {
    $_SESSION['is_super_admin'] = true;
    echo "✅ Super admin mode enabled!<br>";
    echo "<a href='/admin/dashboard.php'>Go to Dashboard</a>";
} else {
    echo "Please login first";
}
```

Visit: `http://localhost/Multi-Tanent/set_super_admin.php`

---

### Issue: "Column not found" errors

**Solution: Run migrations**
```bash
php database/run_all_missing_columns.php
```

Expected output:
```
✓ Successfully Added: X items
✗ Errors: 0
```

---

### Issue: School selector shows no schools

**Solution: Check academy_references table**
```sql
-- View all schools
SELECT * FROM academy_references;

-- Should show at least KINE and TEST

-- If empty, create default:
INSERT INTO academy_references (admin_id, academy_name, reference_code, is_active)
VALUES (1, 'Kine Academy', 'KINE', 1);
```

---

### Issue: Students not showing in dashboard

**Solution: Check academy_reference assignment**
```sql
-- Check students' school assignment
SELECT id, first_name, last_name, academy_reference FROM students LIMIT 10;

-- If NULL, assign to KINE:
UPDATE students SET academy_reference = 'KINE' WHERE academy_reference IS NULL;
```

---

### Issue: Cannot switch schools

**Solution: Check school_context.php is included**
```php
// Add to top of page
require_once '../includes/school_context.php';
requireSchool();
```

---

## 📱 Testing URLs Reference

### Public URLs
```
Student Registration:
http://localhost/Multi-Tanent/index.php

Student Login:
http://localhost/Multi-Tanent/register.php
```

### Admin URLs
```
Admin Login:
http://localhost/Multi-Tanent/admin/login.php

School Selector:
http://localhost/Multi-Tanent/select_school.php

Dashboard:
http://localhost/Multi-Tanent/admin/dashboard.php

Create Student:
http://localhost/Multi-Tanent/admin/create.php

School Settings:
http://localhost/Multi-Tanent/admin/settings/school_settings.php
```

### Super Admin URLs
```
Super Dashboard:
http://localhost/Multi-Tanent/super_admin/dashboard.php

Create School:
http://localhost/Multi-Tanent/super_admin/schools/create.php

Manage Schools:
http://localhost/Multi-Tanent/super_admin/schools/list.php

View School:
http://localhost/Multi-Tanent/super_admin/schools/view.php?id=1
```

### Direct School Access
```
Select Kine:
http://localhost/Multi-Tanent/select_school.php?school=KINE

Select Rainbow:
http://localhost/Multi-Tanent/select_school.php?school=RAINBOW

Select St. Mary's:
http://localhost/Multi-Tanent/select_school.php?school=STMARY
```

---

## 🎬 Video Walkthrough Script

### Recording 1: Basic Flow (5 min)

**Script:**
```
1. Open http://localhost/Multi-Tanent/admin/login.php
   "This is the admin login page"

2. Login with admin/admin123
   "After login, we see the school selector"

3. Select Kine Academy
   "This is the dashboard for Kine Academy"
   "Notice the school name in the header"

4. Click "Create Student"
   "Let's add a student to Kine Academy"
   Fill in form and submit

5. Student appears in dashboard
   "The student is now in Kine Academy's system"

6. Click "Switch School"
   "Now let's switch to a different school"

7. Select Rainbow Academy
   "Notice the dashboard is empty - we're in a different school"
   "The student we just created is NOT visible here"
   "Complete data isolation!"

8. Create another student in Rainbow
   "This student belongs to Rainbow Academy"

9. Switch back to Kine
   "Now we only see Kine students again"
   "Perfect multi-tenant isolation!"
```

---

### Recording 2: Super Admin Features (5 min)

**Script:**
```
1. Click "Super Admin" in navigation
   "This is the super admin panel"
   "We can see ALL schools at once"

2. View statistics
   "Total schools: 3"
   "Total students: across all schools"
   "Total revenue: combined"

3. Click "Add New School"
   "Super admin can create new schools"
   Fill in form for "Grace Academy"

4. School created successfully
   "New admin account created automatically"
   "Wallet initialized"
   "Default settings applied"

5. Go to "Manage Schools"
   "List of all schools"
   "Can view, edit, suspend any school"

6. Click "View" on Rainbow
   "See detailed statistics for Rainbow"
   "Student count, revenue, wallet balance"

7. Click "Access School"
   "Super admin can access any school dashboard"
   "Now viewing Rainbow Academy's dashboard"
```

---

## 🧪 Test Scenarios

### Scenario 1: New School Onboarding

**Time:** 10 minutes

**Steps:**
1. ✅ Super admin creates school "Tech Academy" (CODE: TECH)
2. ✅ Logout from super admin
3. ✅ Login as `tech_admin` / provided password
4. ✅ Automatically in Tech Academy
5. ✅ Go to School Settings
6. ✅ Customize: name, colors, contact info
7. ✅ Create first student
8. ✅ Verify student has academy_reference = 'TECH'

**Verification:**
```sql
SELECT first_name, last_name, academy_reference 
FROM students 
WHERE academy_reference = 'TECH';
```

---

### Scenario 2: Cross-School Security Test

**Time:** 5 minutes

**Steps:**
1. ✅ Login as Kine admin
2. ✅ Note a Kine student ID (e.g., ID=100)
3. ✅ Get Rainbow student ID (e.g., ID=101)
4. ✅ Try to access: `edit.php?id=101` while in Kine
5. ✅ Expected: Access denied / redirect to dashboard
6. ✅ Try to delete Rainbow student from Kine
7. ✅ Expected: Blocked

**SQL Verification:**
```sql
-- Check student isolation
SELECT 
    s.id, 
    s.first_name, 
    s.academy_reference,
    a.username as current_admin,
    a.academy_reference as admin_school
FROM students s
CROSS JOIN admins a
WHERE a.username = 'admin'
ORDER BY s.academy_reference;
```

---

### Scenario 3: Payment Flow Test

**Time:** 15 minutes

**Setup:** Create payments for different schools

```sql
-- Payment for Kine student
INSERT INTO payments 
(student_id, amount, currency, reference_id, external_id, msisdn, status, payment_method, academy_reference, platform_fee, admin_earnings, created_at)
VALUES 
(100, 3.00, 'SZL', UUID(), 'KINE001', '76123456', 'SUCCESSFUL', 'MOMO', 'KINE', 0.50, 2.50, NOW());

-- Payment for Rainbow student
INSERT INTO payments 
(student_id, amount, currency, reference_id, external_id, msisdn, status, payment_method, academy_reference, platform_fee, admin_earnings, created_at)
VALUES 
(101, 2.70, 'SZL', UUID(), 'RAIN001', '76789012', 'SUCCESSFUL', 'MOMO', 'RAINBOW', 0.50, 2.20, NOW());
```

**Verification Steps:**
1. ✅ Login as Kine admin
2. ✅ Go to Payments page
3. ✅ Verify: Only Kine payment visible (E3.00)
4. ✅ Check wallet: E2.50
5. ✅ Switch to Rainbow
6. ✅ Verify: Only Rainbow payment visible (E2.70)
7. ✅ Check wallet: E2.20
8. ✅ Login as super admin
9. ✅ Verify platform fees: E1.00 total (E0.50 × 2)

---

### Scenario 4: School Settings Persistence

**Steps:**
1. ✅ Set Rainbow colors to Red/Blue
2. ✅ Set St. Mary's colors to Green/Yellow
3. ✅ Logout
4. ✅ Login again
5. ✅ Switch to Rainbow → Verify Red/Blue
6. ✅ Switch to St. Mary's → Verify Green/Yellow
7. ✅ Settings persisted correctly

---

## 📊 Database Testing Queries

### Check Multi-Tenant Structure
```sql
-- View all schools
SELECT * FROM academy_references;

-- View students per school
SELECT 
    academy_reference,
    COUNT(*) as student_count,
    GROUP_CONCAT(CONCAT(first_name, ' ', last_name)) as students
FROM students
WHERE deleted_at IS NULL
GROUP BY academy_reference;

-- View payments per school
SELECT 
    academy_reference,
    COUNT(*) as payment_count,
    SUM(amount) as total_revenue,
    SUM(admin_earnings) as school_earnings,
    SUM(platform_fee) as platform_earnings
FROM payments
WHERE status = 'SUCCESSFUL'
GROUP BY academy_reference;

-- View platform fees
SELECT 
    academy_reference,
    payment_method,
    COUNT(*) as count,
    SUM(fee_amount) as total_fees
FROM platform_fees
GROUP BY academy_reference, payment_method;

-- View school settings
SELECT 
    academy_reference,
    setting_key,
    setting_value
FROM tenant_settings
ORDER BY academy_reference, setting_key;
```

---

## 🎯 Performance Testing

### Test Query Speed
```sql
-- Test student query with index
EXPLAIN SELECT * FROM students WHERE academy_reference = 'KINE';

-- Should show:
-- type: ref
-- key: idx_students_academy_ref
-- rows: [actual count]
```

### Test Concurrent Access
```
1. Open 3 different browsers
2. Login to different schools in each
3. Perform actions simultaneously
4. Verify no data mixing
5. Check response times remain fast
```

---

## 📱 Mobile Testing

### Test Responsive Design
1. Open browser dev tools (F12)
2. Toggle device toolbar
3. Test on mobile sizes:
   - iPhone SE (375px)
   - iPad (768px)
   - Desktop (1920px)

**Check:**
- ✅ School selector looks good
- ✅ Dashboard responsive
- ✅ Forms usable on mobile
- ✅ Navigation works

---

## 🔧 Developer Testing Tools

### Test Script #1: Quick Isolation Test
```bash
php tools/test_multi_tenant_isolation.php
```

### Test Script #2: Check Current State
Create `check_system.php`:
```php
<?php
require_once 'config.php';
$pdo = getDB();

echo "=== SYSTEM STATUS ===\n\n";

// Count schools
$schools = $pdo->query("SELECT COUNT(*) FROM academy_references WHERE is_active=1")->fetchColumn();
echo "Active Schools: $schools\n";

// Count students per school
$stmt = $pdo->query("
    SELECT academy_reference, COUNT(*) as count 
    FROM students 
    WHERE deleted_at IS NULL 
    GROUP BY academy_reference
");
echo "\nStudents per School:\n";
while ($row = $stmt->fetch()) {
    echo "  {$row['academy_reference']}: {$row['count']}\n";
}

// Count payments
$total = $pdo->query("SELECT COUNT(*) FROM payments WHERE status='SUCCESSFUL'")->fetchColumn();
echo "\nTotal Successful Payments: $total\n";

// Platform fees
$fees = $pdo->query("SELECT SUM(platform_fee) FROM payments WHERE status='SUCCESSFUL'")->fetchColumn();
echo "Total Platform Fees: E" . number_format($fees, 2) . "\n";
```

Run: `php check_system.php`

---

## ✅ Final Testing Checklist

Print this and check off as you test:

### Database
- [ ] Test suite passes
- [ ] All tables exist
- [ ] Indexes created
- [ ] Data migrated

### Authentication
- [ ] Super admin can login
- [ ] School admin can login
- [ ] School context sets correctly
- [ ] Logout clears context

### School Management
- [ ] Can create new school
- [ ] Can edit school
- [ ] Can suspend/activate school
- [ ] Can view school details

### Student Management
- [ ] Create student in School A
- [ ] Student has correct academy_reference
- [ ] Switch to School B
- [ ] School A student not visible
- [ ] Create student in School B
- [ ] School B student visible

### Security
- [ ] Cross-school access blocked
- [ ] URL manipulation prevented
- [ ] School admin restricted to own school
- [ ] Super admin can access all

### Settings
- [ ] School settings save
- [ ] Settings load correctly
- [ ] Each school independent
- [ ] Branding applies

### Payments
- [ ] Payments filtered by school
- [ ] Platform fee calculated
- [ ] Admin earnings correct
- [ ] Wallet balance accurate

---

## 🎊 You're Ready!

Once all checklist items are ✅, your system is **PRODUCTION READY**!

---

**Happy Testing!** 🧪

**Questions?** Check the troubleshooting sections or run the test suite!

**Issues?** Review `MULTI_TENANT_README.md` for detailed explanations.

🚀 **Your multi-tenant system awaits!** 🚀

