# ⚡ QUICK FIX - SUBJECTS TABLE (1 Minute)

## 🎯 The Problem
```
❌ Error: Duplicate entry 'Mathematics' for key 'name'
```

## 🔧 The Fix (Copy-Paste This)

### **In phpMyAdmin SQL Tab:**

```sql
-- 1. Backup
CREATE TABLE subjects_backup AS SELECT * FROM subjects;

-- 2. Remove UNIQUE from 'name'
ALTER TABLE subjects DROP INDEX name;

-- 3. Ensure 'code' is UNIQUE
ALTER TABLE subjects ADD UNIQUE KEY unique_code (code);

-- 4. Clean slate (OPTIONAL - removes all subjects)
SET FOREIGN_KEY_CHECKS = 0;
TRUNCATE TABLE grade_subject;
TRUNCATE TABLE subjects;
SET FOREIGN_KEY_CHECKS = 1;

-- 5. Verify
SHOW INDEXES FROM subjects;
```

### **Then Import:**

1. Go to phpMyAdmin **Import** tab
2. Choose: `database/ESWATINI_CURRICULUM_SUBJECTS.sql`
3. Click **Go**
4. Wait for completion
5. ✅ Done!

---

## ✅ Verify Success

```sql
-- Should return 150-200+
SELECT COUNT(*) FROM subjects;

-- Should show multiple Mathematics
SELECT name, code FROM subjects 
WHERE name LIKE '%Mathematics%'
ORDER BY code;

-- Should show subjects per grade
SELECT g.name, COUNT(gs.subject_id) as subjects
FROM grades g
LEFT JOIN grade_subject gs ON g.id = gs.grade_id
GROUP BY g.name;
```

---

## 📊 Result

**Before:**
- ❌ Only 1 "Mathematics" allowed
- ❌ Import fails with duplicates

**After:**
- ✅ Multiple "Mathematics" (G4, G5, G6, etc.)
- ✅ Import successful
- ✅ Ready for Moodle mapping

---

## 🎉 Success When:

- ✅ No errors during ALTER TABLE
- ✅ Import completes successfully
- ✅ COUNT returns 150-200+ subjects
- ✅ Multiple Mathematics entries exist

---

**Time: 1 minute**  
**Risk: Low (includes backup)**  
**Result: Complete curriculum imported! 🚀**

---

*For detailed guide, see: `FIX_SUBJECTS_DUPLICATE_GUIDE.md`*

