# Skolo-Kine Student Registration System

A comprehensive student registration system with email verification, admin dashboard, and Moodle export functionality.

## Features

### Student Registration
- ✅ **Form Validation** - Real-time client-side and server-side validation
- ✅ **Email Verification** - Secure email verification with 24-hour token expiration
- ✅ **Subject Selection** - Easy checkbox interface for Grade 7 subjects
- ✅ **Password Security** - Strong password requirements with confirmation

### Admin Dashboard
- ✅ **Student Management** - View, edit, and delete student records
- ✅ **Email Status Tracking** - Monitor email verification status
- ✅ **Statistics** - Registration statistics and analytics
- ✅ **Export Features** - Excel and Moodle CSV export

### Email System
- ✅ **Verification Emails** - Professional HTML email templates
- ✅ **Login Credentials** - Automatic credential delivery after verification
- ✅ **SMTP Integration** - Configurable SMTP settings

### Export Features
- ✅ **Excel Export** - General-purpose Excel file generation
- ✅ **Moodle CSV** - Direct import format for Moodle LMS
- ✅ **Subject Codes** - Properly formatted subject codes (e.g., SCI7100)
- ✅ **Password Format** - Student passwords set to their last name

## Quick Start

### 1. Installation
1. Upload files to your web server
2. Create MySQL database and user
3. Import `database/schema.sql`
4. Copy `config.production.php` to `config.php` and configure
5. Run `setup_grade7_subjects.php`
6. Test with `test_installation.php`

### 2. Configuration
Update `config.php` with your settings:
- Database credentials
- SMTP email settings
- Admin password
- Application settings

### 3. Security
- Delete setup files after installation
- Set proper file permissions
- Enable .htaccess protection
- Use strong passwords

## File Structure

```
Skolo-Kine/
├── admin/                 # Admin dashboard files
├── app/                   # Application classes
├── config/                # Configuration files
├── database/              # Database schema and migrations
├── exports/               # Generated Excel/CSV files
├── includes/              # Core functions
├── vendor/                # Composer dependencies
├── .htaccess              # Apache configuration
├── config.php             # Main configuration
├── index.php              # Registration form
├── register.php           # Registration handler
├── success.php            # Success page
├── verify-email.php       # Email verification
└── README.md              # This file
```

## Grade 7 Subjects

The system comes pre-configured with Grade 7 subjects:

1. **Mathematics** (MAT7100)
2. **English** (ENG7100)
3. **Siswati** (SIS7100)
4. **Religious Education** (REL7100)
5. **Social Studies** (SOC7100)
6. **Expressive Arts** (EXP7100)
7. **Agriculture** (AGR7100)
8. **Consumer Science** (CON7100)
9. **HPE** (HPE7100)
10. **Science** (SCI7100)
11. **ICT** (ICT7100)

## Subject Code Format

Subject codes follow the format: **First 3 letters + Grade number + 100**

Examples:
- Grade 7 Science: `SCI7100`
- Form 1 Science: `SCI1100`
- Grade 8 Mathematics: `MAT8100`

## Email Verification Process

1. **Registration** - Student fills out form
2. **Email Sent** - Verification email with secure token
3. **Verification** - Student clicks link to verify email
4. **Credentials** - Login credentials sent after verification
5. **Complete** - Student can now access the system

## Admin Features

### Dashboard
- Student statistics and analytics
- Email verification status tracking
- Recent registrations overview

### Student Management
- View all registered students
- Edit student information
- Delete student records
- Export student data

### Export Options
- **Excel Export** - For general use and reporting
- **Moodle CSV** - Direct import to Moodle LMS
- **Preview** - See data before downloading

## Security Features

- **CSRF Protection** - All forms protected against CSRF attacks
- **Email Verification** - Prevents fake registrations
- **Secure Tokens** - 64-character random verification tokens
- **File Protection** - Sensitive files protected via .htaccess
- **Input Validation** - Comprehensive input sanitization
- **SQL Injection Protection** - Prepared statements throughout

## Requirements

### Server Requirements
- PHP 7.4+ (8.0+ recommended)
- MySQL 5.7+ (8.0+ recommended)
- Apache/Nginx web server
- SMTP email capability

### PHP Extensions
- PDO MySQL
- OpenSSL
- cURL
- mbstring
- fileinfo
- zip

## Installation Guide

See `INSTALLATION_GUIDE.md` for detailed installation instructions.

## Deployment Checklist

See `DEPLOYMENT_CHECKLIST.md` for a comprehensive deployment checklist.

## Support

For support and troubleshooting:
1. Check the installation guide
2. Run the test installation script
3. Review error logs
4. Contact your hosting provider for server-specific issues

## License

This project is proprietary software for Kine Academy.

## Changelog

### Version 1.0.0
- Initial release
- Student registration with email verification
- Admin dashboard
- Grade 7 subject configuration
- Excel and Moodle export functionality
- Comprehensive form validation
- Security features and protection

---

**Skolo-Kine Student Registration System**  
*Professional student registration with email verification and admin management*
