# 🎓 Student Self-Registration System - Complete Implementation Guide

## ✅ What Was Implemented

A complete student self-registration system where students can register themselves **without admin intervention** using school-specific URLs.

---

## 🏗️ Architecture

```
Student visits school-specific URL
         ↓
Multi-step registration form
  1. Personal Info
  2. Grade & Subject Selection
  3. Parent Info
  4. Review & Submit
         ↓
Email verification sent
         ↓
Student clicks verification link
         ↓
Payment page (MoMo/Card)
         ↓
Payment processed
         ↓
Account auto-created
  - Username generated (YYYYMMDDNN)
  - Password generated
  - Enrolled in subjects
  - Parent account created/linked
  - (Optional) Moodle enrollment
         ↓
Credentials sent via email & SMS
         ↓
Student can login immediately!
```

---

## 📁 Files Created

### **1. Database Schema**
```
database/migrations/create_student_applications_table.sql
```
Creates 2 tables:
- `student_applications` - Stores registration applications
- `student_application_subjects` - Selected subjects per application

### **2. Registration Form**
```
register_student.php
```
- Multi-step form (4 steps)
- School-specific branding
- Real-time subject loading
- Fee calculation
- Validation

### **3. Email Verification**
```
verify_registration.php
```
- Validates verification token
- 48-hour expiry
- Redirects to payment

### **4. Payment Processing**
```
payment_for_application.php
```
- Shows application summary
- MoMo and card payment
- Triggers account creation

### **5. Account Creator**
```
includes/student_account_creator.php
```
- Generates username & password
- Creates student record
- Enrolls in subjects
- Creates/links parent account
- Moodle enrollment
- Sends credentials

### **6. Success Page**
```
registration_complete.php
```
- Shows credentials
- Copy to clipboard
- Print option
- Direct login link

### **7. Admin Interface**
```
admin/applications/list.php
```
- View all applications
- Filter by status
- Statistics dashboard
- Detailed view

---

## 🚀 Deployment Steps

### **Step 1: Run SQL Migrations**

In phpMyAdmin:

**1.1. Create Applications Tables**
```sql
-- File: create_student_applications_table.sql
-- Creates: student_applications, student_application_subjects
```

**1.2. Create School Grades Table**
```sql
-- File: create_school_grades_table.sql
-- Creates: school_grades (for grade selection per school)
```

**1.3. Add Primary Grades**
```sql
INSERT IGNORE INTO grades (name) VALUES
('Grade 4'), ('Grade 5'), ('Grade 6'), ('Grade 7');
```

**1.4. Add Primary Subjects**
```sql
-- File: primary_school_subjects_g4_g7.sql
-- Creates: 48 subjects for Grade 4-7
```

---

### **Step 2: Upload PHP Files**

Upload to cPanel (`Multi-Tanent/`):

**Public Files:**
- `register_student.php` - Main registration form
- `verify_registration.php` - Email verification handler
- `payment_for_application.php` - Payment processing
- `registration_complete.php` - Success page

**Includes:**
- `includes/student_account_creator.php` - Account creation logic

**Admin Files:**
- `admin/manage_grades.php` - Grade selection interface
- `admin/applications/list.php` - View applications
- `admin/configure_subjects.php` - (Already updated)

---

### **Step 3: Configure School Settings**

In admin panel → School Settings, add:

```
Enable Student Self-Registration: ✓ Yes
Subject Fee: E350.00
Currency Symbol: E
School Email: info@yourschool.com
```

---

### **Step 4: Select Your Grades**

1. Go to: `admin/manage_grades.php`
2. Select grades your school offers
3. Save configuration

---

### **Step 5: Configure Subjects Per Grade**

1. Go to: `admin/configure_subjects.php`
2. For each enabled grade, assign subjects
3. Save

---

### **Step 6: Share Registration Link**

Your school-specific registration URL:
```
https://test.melanegroup.com/Multi-Tanent/register_student.php?school=KINE

Replace "KINE" with your academy_reference
```

**Share via:**
- School website
- Social media
- WhatsApp groups
- Email newsletters
- QR codes on posters
- SMS campaigns

---

## 🎯 School-Specific URLs

### **How It Works:**

Each school has a unique registration link:

```
School A (KINE):
https://test.melanegroup.com/Multi-Tanent/register_student.php?school=KINE

School B (SCH002):
https://test.melanegroup.com/Multi-Tanent/register_student.php?school=SCH002

School C (STMARYS):
https://test.melanegroup.com/Multi-Tanent/register_student.php?school=STMARYS
```

**Benefits:**
- ✅ Automatic school identification
- ✅ No dropdown confusion
- ✅ School-specific branding (logo, colors)
- ✅ Tracks which link was used
- ✅ Easy to share

---

## 📊 Student Registration Flow

### **Step 1: Student Visits Link**

```
https://test.melanegroup.com/Multi-Tanent/register_student.php?school=KINE
```

Sees:
- KINE Academy logo
- School name
- School colors
- Registration form

---

### **Step 2: Multi-Step Form**

**Step 1/4: Personal Information**
- First Name, Last Name
- Email
- Phone
- Date of Birth
- Gender

**Step 2/4: Academic Information**
- Select Grade (only sees enabled grades)
- Select Subjects (loads based on grade)
- Core subjects auto-selected (English, Math)
- Fee calculated in real-time

**Step 3/4: Parent/Guardian Information**
- Parent Name
- Parent Email
- Parent Phone (for MoMo)
- Relationship

**Step 4/4: Review & Submit**
- Review all information
- See total fee
- Accept terms
- Submit

---

### **Step 3: Email Verification**

System sends email to student:
```
Subject: Verify Your Registration - KINE Academy

Dear John Doe,

Thank you for registering!

[Verify Email & Proceed to Payment] (button)

Application Summary:
- School: KINE Academy
- Subjects: 6
- Total Fee: E2,100.00

This link expires in 48 hours.
```

Student clicks link → Redirected to `verify_registration.php`

---

### **Step 4: Payment**

After verification, student sees:
```
✅ Email Verified!

Application Summary:
- Student: John Doe
- Grade: Grade 7
- Subjects: 6 (English, Math, Science...)
- Total: E2,100.00

Select Payment Method:
○ MTN MoMo
○ Credit/Debit Card

[Pay E2,100.00 & Complete Registration]
```

---

### **Step 5: Account Creation**

After successful payment:
- ✅ Student account created
- ✅ Username: `2025110501`
- ✅ Password: `A3F9C2D8`
- ✅ Enrolled in selected subjects
- ✅ Parent account created (if new)
- ✅ Parent linked to student
- ✅ (Optional) Enrolled in Moodle courses

---

### **Step 6: Credentials Delivered**

**Email to Student:**
```
Your Student Account is Ready!

Username: 2025110501
Password: A3F9C2D8

[Login to Your Account] (button)

Important: Change password after first login.
```

**SMS to Student:**
```
Your school account: 
Username: 2025110501
Password: A3F9C2D8
Login: test.melanegroup.com
```

**Email to Parent:**
```
Parent Portal Account Created

Email: parent@example.com
Password: generatedpassword

[Login to Parent Portal] (button)

View your child's progress and make payments.
```

---

## 👨‍💼 Admin Features

### **View Applications**

**URL:** `admin/applications/list.php`

**Features:**
- Statistics dashboard
- Filter by status (All, Pending, Verified, Completed, Rejected)
- View application details
- See payment status
- Track submissions

**Table Columns:**
- Application ID
- Student Name
- Email (with verification status)
- Grade
- Subject count
- Application status
- Payment status & amount
- Submission date
- Actions (View, Approve, Reject)

---

## 🔐 Security Features

### **1. Email Verification**
- Prevents fake emails
- 48-hour expiry
- One-time use tokens
- Validates before payment

### **2. Duplicate Prevention**
- Checks email not already registered
- Checks no pending application
- Per-school validation

### **3. School Validation**
- Verifies school code exists
- Checks school is active
- Verifies self-registration enabled

### **4. Grade Validation**
- Only shows grades school offers
- Uses school_grades table
- Age-appropriate filtering

### **5. Payment Security**
- Payment required before account creation
- Payment reference tracking
- Secure payment processing

---

## 🎨 Customization Per School

Each school's registration page shows:

```php
// School-specific branding:
- School logo
- School name
- School colors (primary & secondary)
- Only their enabled grades
- Their subject pricing
- Their payment methods
```

**Example:**

**KINE Academy:**
- Logo: KINE logo
- Colors: Blue & Purple
- Grades: Grade 7, Form 1-5
- Fee: E350/subject

**St. Mary's:**
- Logo: St. Mary's logo
- Colors: Red & Gold
- Grades: Grade 4-7
- Fee: E400/subject

---

## 📧 Email Templates

### **Verification Email:**
```html
<h2>Welcome to [School Name]!</h2>
<p>Dear [Student Name],</p>
<p>Please verify your email...</p>
[Verify Email Button]
Application Summary
```

### **Credentials Email:**
```html
<h2>Your Student Account is Ready!</h2>
<p>Username: [Generated]</p>
<p>Password: [Generated]</p>
[Login Button]
```

### **Parent Account Email:**
```html
<h2>Parent Portal Access</h2>
<p>Email: [Parent Email]</p>
<p>Password: [Generated]</p>
[Login to Parent Portal Button]
```

---

## 🧪 Testing Checklist

### **Student Registration:**
- [ ] Visit: `register_student.php?school=KINE`
- [ ] Fill Step 1 (Personal Info)
- [ ] Fill Step 2 (Grade & Subjects)
- [ ] Fill Step 3 (Parent Info)
- [ ] Review Step 4
- [ ] Submit application
- [ ] Receive verification email
- [ ] Click verification link
- [ ] Redirected to payment page
- [ ] Complete payment (MoMo or Card)
- [ ] Account created
- [ ] Receive credentials email
- [ ] Login successfully
- [ ] See enrolled subjects
- [ ] Parent can login to parent portal

### **Admin Monitoring:**
- [ ] View applications: `admin/applications/list.php`
- [ ] See statistics
- [ ] Filter by status
- [ ] View application details
- [ ] Track payment status
- [ ] See completed registrations

### **Multi-School:**
- [ ] School A registration works
- [ ] School B registration works
- [ ] No cross-contamination
- [ ] Each sees own applications only

---

## 🔧 Optional Features (Future Enhancement)

### **Phase 2:**
- Admin approval workflow (approve/reject before payment)
- Document upload (birth certificate, photo)
- Sibling discount detection
- Bulk approve applications
- Export to Excel

### **Phase 3:**
- WhatsApp notifications
- SMS payment confirmations
- Online exam/placement test
- Waitlist for full grades
- Registration analytics dashboard

---

## 📋 Database Tables

### **student_applications**
Stores all registration submissions

### **student_application_subjects**
Tracks selected subjects

### **school_grades**
Which grades each school offers

### **students** (existing)
Final student accounts

### **student_subject** (existing)
Subject enrollments

### **parents** (existing)
Parent accounts

---

## 🎯 Summary

### **Student Experience:**
1. Gets school-specific link
2. Fills 4-step form
3. Receives verification email
4. Completes payment
5. Gets instant account
6. Can login immediately

### **Admin Experience:**
1. Shares registration link
2. Monitors applications
3. Sees real-time statistics
4. No manual data entry needed
5. Automated account creation

### **Parent Experience:**
1. Gets parent portal account automatically
2. Can monitor child's progress
3. Can make future payments
4. No separate registration needed

---

## 🚀 Deployment Summary

**Run SQL (4 scripts):**
1. create_student_applications_table.sql
2. create_school_grades_table.sql
3. add_primary_grades.sql
4. primary_school_subjects_g4_g7.sql

**Upload Files (7 files):**
1. register_student.php
2. verify_registration.php
3. payment_for_application.php
4. registration_complete.php
5. includes/student_account_creator.php
6. admin/manage_grades.php
7. admin/applications/list.php

**Configure:**
1. Select your grades (manage_grades.php)
2. Configure subjects (configure_subjects.php)
3. Share your registration URL

**Done!** Students can now self-register! 🎉

---

## 📞 Support & Troubleshooting

### **Issue: "Invalid school code"**
- Check URL has correct ?school=CODE
- Verify school exists in academy_references
- Check school is_active = 1

### **Issue: "Self-registration not enabled"**
- Go to admin settings
- Enable: student_self_registration = 1

### **Issue: Email not received**
- Check spam folder
- Verify email address correct
- Check server mail() function works
- Consider using SMTP email service

### **Issue: Payment not processing**
- Check payment gateway credentials
- Verify MoMo number format
- Check payment table for errors

---

**Your complete student self-registration system is ready to deploy!** 🚀

