# 📤 Files to Upload to cPanel - Quick Reference

## ✅ **Fixed Files (Upload These)**

### **PHP Files to Upload:**
```
1. super_admin/schools/create.php          - ENHANCED: Default pricing + max students + filtering mode
2. super_admin/schools/list.php            - Fixed description field warnings
3. super_admin/schools/view.php            - ENHANCED: Shows capacity % + filtering mode
4. super_admin/schools/edit.php            - ENHANCED: Edit max students + filtering mode
5. super_admin/dashboard.php               - FIXED: Access dashboard + school selection
6. super_admin/reports/platform_fees.php   - NEW: Platform earnings report
7. super_admin/reports/system_health.php   - NEW: System health monitor
8. includes/school_context.php             - FIXED: Super admin access to school dashboards
9. includes/functions.php                  - FIXED: getDashboardStats now filters by school
10. admin/dashboard.php                    - ENHANCED: Compact filters + export options
11. admin/settings.php                     - NEW: Full settings with Moodle & Email tests
12. admin/export_students.php              - FIXED: Super admin export access
13. includes/parent_functions.php          - NEW: Parent portal helper functions
14. includes/security_init.php             - NEW: Security headers
15. parent_register.php                    - NEW: Parent registration (AUTO-LOGIN!)
16. parent_login.php                       - NEW: Parent authentication
17. parent/dashboard.php                   - NEW: Parent dashboard
18. manifest.json                          - NEW: PWA manifest
19. backups/daily_backup.sh                - NEW: Automated backup script
20. database/PERFORMANCE_INDEXES.sql       - NEW: Performance optimization (FIXED!)
21. database/PARENT_PORTAL_TABLES.sql      - NEW: Parent tables (FIXED!)
22. database/QUICK_FIX_SQL_ERRORS.sql      - NEW: SQL error fix
23. database/ADD_PRICING_TO_EXISTING_SCHOOLS.sql - NEW: Add pricing to existing schools
24. logout.php                             - NEW: Universal logout handler
25. parent/make_payment.php                - NEW: Subject selection & payment
26. parent/process_payment.php             - NEW: Payment confirmation
27. parent/payment_success.php             - NEW: Payment success page
```

### **SQL Script to Run:**
```
13. FIX_SCHOOL_ADMIN_LINKS.sql             - Links schools to their admins
```

---

## 📋 **Step-by-Step Upload Instructions**

### **Step 1: Upload PHP Files via cPanel File Manager**

1. Login to **cPanel** → Click **File Manager**
2. Navigate to: `/public_html/test.melanegroup.com/Multi-Tanent/`
3. Upload each file to its directory:

**Upload to `super_admin/`:**
   - dashboard.php

**Upload to `super_admin/schools/`:**
   - create.php
   - list.php
   - view.php
   - edit.php

**Create directory `super_admin/reports/` and upload:**
   - platform_fees.php
   - system_health.php

**Upload to `includes/`:**
   - school_context.php
   - functions.php

**Upload to `admin/`:**
   - dashboard.php
   - settings.php
   - export_students.php

4. Confirm **"Overwrite"** when prompted

---

### **Step 2: Run SQL Script**

1. Login to **cPanel** → Click **phpMyAdmin**
2. Select your database (left sidebar)
3. Click **SQL** tab
4. Copy the contents of `FIX_SCHOOL_ADMIN_LINKS.sql`
5. Paste into SQL query box
6. Click **Go**
7. Verify the results show schools linked to admins

---

## ✅ **What Was Fixed**

### **Database Column Issues:**
- ✅ Removed non-existent `description` column from school creation
- ✅ Fixed `admin_wallet` INSERT (removed `currency`, `created_at`)
- ✅ Fixed wallet column names: `total_earned` → `total_earnings`, `total_withdrawn` → `withdrawn`
- ✅ Removed `deleted_at` checks (column doesn't exist)
- ✅ Changed payment status from `SUCCESSFUL` to `completed`
- ✅ Fixed student name fields to use `full_name`
- ✅ Fixed `admin_username` NULL warnings

### **School-Admin Links:**
- ✅ SQL script links all schools to their corresponding admin accounts
- ✅ Ensures admin usernames show correctly in lists

### **New Reports Pages:**
- ✅ Platform Fees Report: Track all platform earnings by school
- ✅ System Health Monitor: Real-time system status and metrics
- ✅ Auto-refresh every 30 seconds on health page

### **Enhanced School Editing:**
- ✅ Edit school name, email, phone, address
- ✅ Edit academic year and active status
- ✅ Edit admin MoMo number (with +268 prefix)
- ✅ Edit brand colors (primary & secondary)
- ✅ **NEW: Set maximum student limit** (1-10,000 students)
- ✅ **NEW: Configure table filtering mode:**
  - **Auto (Recommended):** Automatically selects best method based on student count
    - Client-side for <2,000 students (fast, uses browser memory)
    - Server-side for 3,000+ students (efficient, scalable)
  - **Client-side:** Force JavaScript filtering (for small schools)
  - **Server-side:** Force PHP/AJAX filtering (for large schools)
  - Dynamic help text explains each option
- ✅ Quick actions: Reset password, Access dashboard, Suspend/Activate
- ✅ Beautiful, user-friendly interface with validation

### **School Context Banner (User/School Marker):**
- ✅ **Super Admin Mode Banner:** Yellow banner showing:
  - "Super Admin Mode" indicator
  - School being viewed
  - Current username
  - Quick links: "Back to Super Admin" and "School Details"
- ✅ **School Admin Banner:** Blue banner showing:
  - School name and logo
  - Current username
  - School reference code
  - Current date
- ✅ Clear visual distinction between super admin and regular admin

### **School-Specific Dashboard (CRITICAL FIX):**
- ✅ **Personalized Welcome:** Shows "Welcome, [School Name]" instead of generic "Welcome, Admin"
- ✅ **School Context:** Description mentions the specific school reference code
- ✅ **FIXED: Removed Hardcoded Kine Academy card** - Was showing on all dashboards
- ✅ **FIXED: getDashboardStats()** - Now filters all data by current school
- ✅ **Each school sees ONLY their own data:**
  - Student counts
  - Recent registrations
  - Email verification stats
  - Payment data
  - All metrics are school-specific
- ✅ **Dynamic Favicon:** Browser tab shows school's logo
- ✅ **Logo in Navbar:** School logo appears in navigation bar
- ✅ **Logo in Banner:** School logo appears in context banner (for school admins)
- ✅ **Fallback:** Uses default Melane logo if school hasn't uploaded one
- ✅ **Dynamic Student Capacity:** 
  - "Remaining Spots" card now uses school-specific limit
  - Super admin can set different max for each school
  - Default: 500 students (configurable 1-10,000)
  - Shows enrollment percentage and remaining spots
- ✅ **Smart Table Filtering System:**
  - Super admin configures filtering mode per school
  - **Auto Mode (Default):** Intelligent selection based on student count
  - **Client-side Mode:** Fast JavaScript filtering (<2,000 students)
  - **Server-side Mode:** Efficient AJAX filtering (3,000+ students)
  - Visual indicator shows active filtering mode (super admin only)
  - Optimizes performance based on school size
- ✅ **Compact Modern Filters:**
  - Collapsible filter panel (toggle to show/hide)
  - Two-tier system: Main filters + Advanced filters (nested)
  - "Active" badge when filters applied
  - Auto-expands when filters are active
  - Professional Bootstrap 5 design
  - Saves 60-100% vertical space

### **NEW: Admin Settings Page (admin/settings.php):**
- ✅ **School Information:** Edit name, email, phone, address, academic year
- ✅ **Logo Upload:** Upload school logo (JPG, PNG, SVG, WebP)
- ✅ **Brand Colors:** Color pickers for primary and secondary colors
- ✅ **Moodle API Integration (SUPER ADMIN ONLY):**
  - 🔒 **Restricted Access:** Only super admins can configure Moodle API
  - Enable/disable Moodle sync
  - Configure Moodle URL, API token, service name
  - Help guide for getting Moodle token
  - Toggle to show/hide settings
  - ✨ **TEST CONNECTION** button - Verifies Moodle API credentials
  - Shows Moodle site name and version on success
  - **School admins see:** Read-only status showing if Moodle is enabled/disabled
- ✅ **Email Settings:**
  - Default: info@melanegroup.com (read-only for schools)
  - Option to use custom SMTP server
  - Full SMTP configuration (host, port, username, password, encryption)
  - Toggle to show/hide custom settings
  - Email from name and signature
  - ✨ **SEND TEST EMAIL** button - Sends a real test email
  - Verify SMTP settings work before saving
- ✅ **Live Preview:** See current logo before uploading new one
- ✅ **Accessible:** Settings link added to main navigation
- ✅ **Context-Aware:** Shows same banner system as dashboard
- ✅ **Validation:** Form validation for required fields
- ✅ **Security:** Passwords are masked, settings saved securely

### **NEW: Professional Export System (admin/export_students.php):**
- ✅ **4 Export Formats Available:**
  - 📊 **Excel (.xlsx):** Formatted spreadsheet with styled headers
  - 📄 **CSV:** Universal format for import/analysis
  - 📑 **PDF (with Letterhead):** Professional document with school branding
  - 🌐 **HTML (Print View):** Browser-friendly print format
- ✅ **PDF Letterhead Features:**
  - School logo at top
  - School name, address, phone, email
  - Horizontal divider line
  - Report title: "STUDENT LIST REPORT"
  - Generated date and time
  - Total student count
  - Academic year
  - Styled table with alternating rows
  - Footer with school info on each page
  - Professional layout and typography
- ✅ **Excel Features:**
  - School name header (merged cells)
  - Report title
  - Generated timestamp
  - Styled header row (purple background, white text)
  - Auto-sized columns
  - Table borders
  - Professional formatting
- ✅ **CSV Features:**
  - UTF-8 BOM for Excel compatibility
  - All student data fields
  - Clean formatting
- ✅ **HTML Features:**
  - School letterhead with logo
  - Print-optimized styling
  - Contact information footer
  - Print button
  - Responsive design
- ✅ **Smart Export:**
  - Respects all active filters
  - Exports only filtered data
  - Maintains search/grade/subject/date filters
  - File names include school name and date

---

## 🧪 **Test After Upload**

1. **Create New School**
   - Go to Super Admin → Create School
   - Should work without errors

2. **View Super Admin Dashboard**
   - Should show school statistics
   - No warnings or errors

3. **View Schools List**
   - All schools should show admin usernames
   - No "undefined array key" warnings

4. **View Admin Dashboard**
   - Should display correctly
   - Payment stats should work

5. **Test Report Pages**
   - Super Admin → Platform Earnings (should show breakdown by school)
   - Super Admin → System Health (should show system metrics)

6. **Test School Editing**
   - Super Admin → Schools → View School → Edit
   - Change school name, email, colors, etc.
   - Should save all changes successfully

7. **Test School Context Banner**
   - As Super Admin: Access any school dashboard
   - Should see **YELLOW banner** saying "Super Admin Mode"
   - Banner should show school name, your username, and back buttons
   - As School Admin: Login normally
   - Should see **BLUE banner** with school name and your info

8. **Test School-Specific Welcome**
   - Each school should see "Welcome, [Their School Name]"
   - KINE should see "Welcome, Kine Academy"
   - SOSHIGH should see "Welcome, SOS"
   - TEST should see "Welcome, TEST School"

9. **Test Settings Page**
   - Click **Settings** in the navigation
   - **School Information:** Update name, email, phone, address
   - **Logo:** Upload a school logo (JPG, PNG, SVG, WebP)
   - **Colors:** Change brand colors (primary & secondary)
   - **Moodle API (Test as Super Admin):**
     - **As Super Admin:**
       - Toggle "Enable Moodle Integration"
       - Enter Moodle URL and token
       - Settings should show/hide dynamically
       - ✨ **Click "Test Moodle Connection"**
       - Should show success with site name and version
       - OR show error message if credentials are wrong
     - **As School Admin:**
       - Should see warning message: "Restricted Access"
       - Should see current status (Enabled/Disabled)
       - Should see Moodle URL if configured
       - Cannot edit any Moodle settings
   - **Email Settings:**
     - See default email: info@melanegroup.com (should be disabled)
     - Toggle "Use Custom Email Server"
     - Configure SMTP settings (host, port, username, password)
     - Settings should show/hide dynamically
     - ✨ **Enter test email address and click "Send Test Email"**
     - Check your inbox - should receive test email
     - OR show error message if SMTP settings are wrong
   - Save all settings
   - Verify changes persist after page reload

10. **Test School Data Isolation (IMPORTANT!)**
   - Login to KINE school → Check student count
   - Login to SOSHIGH school → Check student count  
   - Login to TEST school → Check student count
   - **Each school should show ONLY their own students**
   - **No "Kine Academy" card should appear**
   - Verify all dashboard metrics are school-specific

11. **Test School Logo & Favicon**
   - Login to a school admin account
   - Go to Settings → Upload a school logo
   - After saving, check:
     - ✅ **Browser Tab:** Should show school logo as favicon
     - ✅ **Navbar:** Logo should appear next to "Admin Dashboard"
     - ✅ **Banner:** Logo should appear in blue context banner
     - ✅ **Unique per School:** Each school has their own logo
   - If no logo uploaded: Should show default Melane logo

12. **Test Maximum Student Limit (Super Admin)**
   - As Super Admin → Schools → Edit School
   - Change "Maximum Students" field (try: 50, 100, 1000)
   - Save changes
   - View school dashboard
   - "Remaining Spots" card should show: [Remaining] / Max [Your Number]
   - View School Details → Should show enrollment percentage
   - Different schools can have different limits

13. **Test Filtering Mode Configuration (Super Admin)**
   - As Super Admin → Schools → Edit School
   - Find "Table Filtering Mode" dropdown
   - Test each option:
     - **Auto:** Help text explains auto-selection logic
     - **Client-side:** Help text explains fast JavaScript filtering
     - **Server-side:** Help text explains efficient AJAX filtering
   - Save changes
   - Access school dashboard as super admin
   - Should see badge in hero section: "🔍 Client-side Filtering (Auto)" or similar
   - View School Details → Should show filtering mode and explanation
   - **Auto mode behavior:**
     - <2,000 students → Uses client-side
     - 3,000+ students → Uses server-side

14. **Test Export System**
   - Login to any school admin dashboard
   - Click "Export" button (top right of student table)
   - Should see dropdown with 4 options:
     - **Excel (.xlsx):** Download → Open in Excel → Should see:
       - School name header
       - Styled purple header row
       - All student data
       - Auto-sized columns
     - **CSV:** Download → Open in Excel/Google Sheets → Should import cleanly
     - **PDF (with Letterhead):** Opens in new tab → Should see:
       - School logo top-left
       - School name and contact info
       - "STUDENT LIST REPORT" title
       - Generated date/time
       - Formatted table with borders
       - School footer on each page
       - Professional letterhead design
     - **HTML (Print View):** Opens in new tab → Should see:
       - School logo and letterhead
       - Print button
       - Back to Dashboard button
       - Can print or save as PDF from browser
   - **Test with Filters:**
     - Apply filters (Grade, Subject, Search)
     - Export → Should only export filtered students
     - Filename includes school name and date

---

## 🔧 **If You Still See Issues**

**Clear cache:**
- Browser cache: Ctrl+Shift+Delete
- PHP OPcache: cPanel → PHP Selector → Options → Reset OPcache

**Check file permissions:**
- All PHP files should be `644`
- Directories should be `755`

**Check error logs:**
- cPanel → Metrics → Errors
- Look for any remaining column errors

---

## 📞 **Support**

If you encounter any issues after uploading:
1. Check the error message carefully
2. Note the file name and line number
3. Share the exact error for quick fixing

**All fixes are complete and ready to deploy!** 🚀

