<?php
require_once '../includes/functions.php';
require_once '../includes/school_context.php';
requireAdminLogin();
requireSchool();

// Get current school context
$currentSchool = getCurrentSchool();

$studentId = (int)($_GET['id'] ?? 0);
$student = null;

if ($studentId > 0) {
    $student = getStudentById($studentId);
    
    // Verify student belongs to current school
    if ($student && $student['academy_reference'] !== $currentSchool && !isSuperAdmin()) {
        // Access denied - student belongs to different school
        header('Location: dashboard.php?error=access_denied');
        exit;
    }
}

if (!$student) {
    header('Location: dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
    if (deleteStudent($studentId)) {
        header('Location: dashboard.php?deleted=1');
        exit;
    } else {
        $error = 'Failed to delete student.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Student - <?php echo APP_NAME; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="../images/img-melanesys-logo.svg">
    <link rel="alternate icon" href="../images/img-melanesys-logo.svg">
    <link rel="apple-touch-icon" href="../images/img-melanesys-logo.svg">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="dashboard.php">
                <i class="bi bi-speedometer2 me-2"></i>Admin Dashboard
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="dashboard.php">
                    <i class="bi bi-arrow-left me-1"></i>Back to Dashboard
                </a>
                <a class="nav-link" href="logout.php">
                    <i class="bi bi-box-arrow-right me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container my-4">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">Delete Student</h2>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow">
                    <div class="card-header bg-danger text-white">
                        <h4 class="card-title mb-0">
                            <i class="bi bi-exclamation-triangle me-2"></i>Confirm Deletion
                        </h4>
                    </div>
                    <div class="card-body">
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger">
                                <i class="bi bi-exclamation-triangle me-1"></i><?php echo htmlspecialchars($error); ?>
                            </div>
                        <?php endif; ?>

                        <div class="alert alert-warning">
                            <h6><i class="bi bi-warning me-1"></i>Warning!</h6>
                            <p class="mb-0">This action cannot be undone. The student will be permanently removed from the system.</p>
                        </div>

                        <div class="card mb-3">
                            <div class="card-body">
                                <h6 class="card-title">Student Information</h6>
                                <p class="mb-1"><strong>Name:</strong> <?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?></p>
                                <p class="mb-1"><strong>Email:</strong> <?php echo htmlspecialchars($student['email']); ?></p>
                                <p class="mb-1"><strong>Grade:</strong> <?php echo htmlspecialchars($student['grade_name']); ?></p>
                                <p class="mb-0"><strong>Username:</strong> <?php echo htmlspecialchars($student['username']); ?></p>
                            </div>
                        </div>

                        <form method="POST" action="delete.php?id=<?php echo $studentId; ?>">
                            <div class="d-flex gap-2">
                                <button type="submit" name="confirm_delete" class="btn btn-danger">
                                    <i class="bi bi-trash me-1"></i>Yes, Delete Student
                                </button>
                                <a href="dashboard.php" class="btn btn-secondary">
                                    <i class="bi bi-x-lg me-1"></i>Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

