<?php
/**
 * Upload Student Photo (Tenant-Aware)
 */

session_start();
require_once '../../config.php';
require_once '../../includes/functions.php';
require_once '../../includes/tenant_directory_manager.php';
require_once '../../includes/tenant_file_upload.php';

// Check authentication
if (!isAdminLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit;
}

$tenant_id = $_SESSION['academy_reference'];

// Database connection
$conn = getDB();

// Initialize upload handler
$dirManager = new TenantDirectoryManager($conn);
$uploader = new TenantFileUpload($conn, $dirManager);

// Handle upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['photo'])) {
    $student_id = (int)$_POST['student_id'];
    
    // Verify student belongs to this tenant
    $stmt = $conn->prepare("
        SELECT id FROM students 
        WHERE id = ? AND academy_reference = ?
    ");
    $stmt->execute([$student_id, $tenant_id]);
    
    if (!$stmt->fetch()) {
        http_response_code(403);
        echo json_encode(['success' => false, 'error' => 'Student not found']);
        exit;
    }
    
    // Upload photo
    $result = $uploader->uploadProfilePhoto(
        $tenant_id,
        $student_id,
        $_FILES['photo']
    );
    
    // Return response
    header('Content-Type: application/json');
    echo json_encode($result);
    exit;
}

http_response_code(400);
echo json_encode(['success' => false, 'error' => 'Invalid request']);

