<?php
/**
 * Test Export Functionality
 * Diagnose why export button isn't working
 */

session_start();
require_once '../includes/functions.php';
require_once '../includes/school_context.php';

echo "<h2>Export Functionality Test</h2>";
echo "<pre>";

echo "1. SESSION CHECK:\n";
echo "   Session ID: " . session_id() . "\n";
echo "   Admin Logged In: " . (isAdminLoggedIn() ? '✅ YES' : '❌ NO') . "\n";
echo "   Admin ID: " . ($_SESSION['admin_id'] ?? 'NOT SET') . "\n";
echo "   Admin Username: " . ($_SESSION['admin_username'] ?? 'NOT SET') . "\n";
echo "   Super Admin: " . (isSuperAdmin() ? '✅ YES' : '❌ NO') . "\n\n";

echo "2. SCHOOL CONTEXT:\n";
$currentSchool = getCurrentSchool();
echo "   Current School: " . ($currentSchool ?? '❌ NOT SET') . "\n";
if ($currentSchool) {
    echo "   School Name: " . (getSchoolName() ?? 'NOT FOUND') . "\n";
    $schoolData = getCurrentSchoolData();
    if ($schoolData) {
        echo "   School Active: " . ($schoolData['is_active'] ? '✅ YES' : '❌ NO') . "\n";
    }
}
echo "\n";

echo "3. DATABASE CONNECTION:\n";
try {
    $pdo = getDB();
    echo "   Database: ✅ CONNECTED\n";
    
    // Test query
    if ($currentSchool) {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM students WHERE academy_reference = ?");
        $stmt->execute([$currentSchool]);
        $studentCount = $stmt->fetchColumn();
        echo "   Students in School: $studentCount\n";
    }
} catch (Exception $e) {
    echo "   Database: ❌ ERROR - " . $e->getMessage() . "\n";
}
echo "\n";

echo "4. EXPORT LINKS:\n";
$queryString = http_build_query($_GET);
echo "   CSV: <a href='export_students.php?format=csv&$queryString' target='_blank'>Test CSV Export</a>\n";
echo "   HTML: <a href='export_students.php?format=html&$queryString' target='_blank'>Test HTML Export</a>\n";
echo "\n";

echo "5. SESSION CONTENTS:\n";
foreach ($_SESSION as $key => $value) {
    if (is_array($value)) {
        echo "   $key: [ARRAY]\n";
    } elseif (is_object($value)) {
        echo "   $key: [OBJECT]\n";
    } else {
        $displayValue = is_bool($value) ? ($value ? 'true' : 'false') : $value;
        echo "   $key: $displayValue\n";
    }
}

echo "</pre>";

if (!isAdminLoggedIn()) {
    echo "<div style='background: #fee; border: 2px solid #f00; padding: 20px; margin: 20px 0;'>";
    echo "<h3>❌ NOT LOGGED IN</h3>";
    echo "<p><a href='login.php'>Go to Login Page</a></p>";
    echo "</div>";
}

if (!$currentSchool) {
    echo "<div style='background: #ffe; border: 2px solid #fa0; padding: 20px; margin: 20px 0;'>";
    echo "<h3>⚠️ NO SCHOOL SELECTED</h3>";
    echo "<p><a href='../select_school.php'>Select a School</a></p>";
    echo "</div>";
}

if (isAdminLoggedIn() && $currentSchool) {
    echo "<div style='background: #efe; border: 2px solid #0a0; padding: 20px; margin: 20px 0;'>";
    echo "<h3>✅ ALL CHECKS PASSED</h3>";
    echo "<p>Export should work. Try the links above.</p>";
    echo "</div>";
}

echo "<hr>";
echo "<p><a href='dashboard.php'>← Back to Dashboard</a></p>";
?>

