<?php
require_once __DIR__ . '/../includes/functions.php';

// Simple API key authentication (you should change this)
$API_KEY = 'skolo_prod_2024_8f9a2b3c4d5e6f7a8b9c0d1e2f3a4b5c';

// Check API key
$provided_key = $_GET['api_key'] ?? $_POST['api_key'] ?? '';
if ($provided_key !== $API_KEY) {
    http_response_code(401);
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Get only verified students
$pdo = getDB();
$stmt = $pdo->query("
    SELECT s.*, g.name as grade_name 
    FROM students s 
    JOIN grades g ON s.grade_id = g.id 
    WHERE s.email_verified = TRUE 
    ORDER BY s.created_at DESC
");
$students = $stmt->fetchAll();

// Prepare CSV data - Extended format: username, firstname, lastname, password, email, grade_name, subject_ids
$csvData = [];
$csvData[] = ['username', 'firstname', 'lastname', 'password', 'email', 'grade_name', 'subject_ids']; // Headers

foreach ($students as $student) {
    // Use last name as password for Moodle import
    $tempPassword = $student['last_name'];
    
    // Get subjects for this student
    $subjects = getSubjectsForStudent($student['id']);
    $subjectIds = array_map(function($s) { return $s['id']; }, $subjects);
    $subjectIdsString = implode(',', $subjectIds);
    
    $csvData[] = [
        formatUsernameForMoodle($student['username']), // Use formatted username for Moodle compatibility
        $student['first_name'],
        $student['last_name'],
        $tempPassword,
        $student['email'],
        $student['grade_name'],
        $subjectIdsString
    ];
}

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="skolo_students_' . date('Y-m-d_H-i-s') . '.csv"');
header('Cache-Control: no-cache, must-revalidate');
header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');

// Create CSV output
$output = fopen('php://output', 'w');

// Add BOM for UTF-8 compatibility with Excel
fwrite($output, "\xEF\xBB\xBF");

foreach ($csvData as $row) {
    fputcsv($output, $row);
}

fclose($output);
?>
