# 📦 Automated Backup Setup Guide

## ⚡ Quick Setup (5 minutes)

### Step 1: Upload Backup Script
```bash
# Upload daily_backup.sh to your server
# Location: /home/melane/backups/daily_backup.sh
```

### Step 2: Configure Database Credentials
```bash
# Edit the script
nano /home/melane/backups/daily_backup.sh

# Update this line with your actual database password:
DB_PASS="YOUR_DATABASE_PASSWORD_HERE"

# Save and exit (Ctrl+X, then Y, then Enter)
```

### Step 3: Make Script Executable
```bash
chmod +x /home/melane/backups/daily_backup.sh
```

### Step 4: Test the Backup
```bash
# Run manually to test
cd /home/melane/backups
./daily_backup.sh

# Check if backup was created
ls -lh database/daily/

# You should see a .sql.gz file
```

### Step 5: Setup Automated Schedule (Cron)
```bash
# Open cron editor
crontab -e

# Add this line (runs daily at 2 AM):
0 2 * * * /home/melane/backups/daily_backup.sh

# Save and exit
```

### Step 6: Verify Cron is Running
```bash
# Check cron jobs
crontab -l

# Check cron service status
service cron status
```

---

## 📁 Backup Structure

After running, you'll have:

```
/home/melane/backups/
├── daily_backup.sh                  (The script)
├── database/
│   ├── daily/                       (Last 7 days)
│   │   ├── backup_20250127_020000.sql.gz
│   │   ├── backup_20250126_020000.sql.gz
│   │   └── ...
│   ├── weekly/                      (Last 4 weeks)
│   │   ├── backup_week04_20250119_020000.sql.gz
│   │   └── ...
│   └── monthly/                     (Last 12 months)
│       ├── backup_202501.sql.gz
│       └── ...
└── logs/
    ├── backup_20250127_020000.log
    └── ...
```

---

## 🔄 How to Restore a Backup

### Restore Latest Backup:
```bash
# Find latest backup
LATEST_BACKUP=$(ls -t /home/melane/backups/database/daily/*.sql.gz | head -1)

# Restore it
gunzip < "$LATEST_BACKUP" | mysql -u melane_user -p melane_kine

# Enter your database password when prompted
```

### Restore Specific Date:
```bash
# List available backups
ls -lh /home/melane/backups/database/daily/

# Restore specific backup (replace with actual filename)
gunzip < /home/melane/backups/database/daily/backup_20250125_020000.sql.gz | mysql -u melane_user -p melane_kine
```

---

## 📊 Monitoring Backups

### Check Backup Status:
```bash
# View latest log
tail -50 /home/melane/backups/logs/backup_*.log | tail -50

# Check backup sizes
du -sh /home/melane/backups/database/*

# Count backups
echo "Daily: $(ls /home/melane/backups/database/daily/*.sql.gz 2>/dev/null | wc -l)"
echo "Weekly: $(ls /home/melane/backups/database/weekly/*.sql.gz 2>/dev/null | wc -l)"
echo "Monthly: $(ls /home/melane/backups/database/monthly/*.sql.gz 2>/dev/null | wc -l)"
```

### Email Notifications (Optional):
```bash
# Edit the script to enable email notifications
nano /home/melane/backups/daily_backup.sh

# Update this line with your email:
NOTIFY_EMAIL="your-email@example.com"

# The script will email you on failures
```

---

## ☁️ Cloud Backup (Recommended!)

### Using Dropbox:
```bash
# Install rclone
curl https://rclone.org/install.sh | sudo bash

# Configure Dropbox
rclone config

# Name: dropbox
# Type: dropbox
# Follow the authentication steps

# Test upload
rclone copy /home/melane/backups/database/daily/ dropbox:backups/database/

# Uncomment cloud upload lines in daily_backup.sh
```

### Using Google Drive:
```bash
# Configure rclone with Google Drive
rclone config

# Name: gdrive
# Type: drive
# Follow the authentication steps

# Edit daily_backup.sh, update cloud upload line:
# rclone copy "$DAILY_BACKUP" gdrive:backups/database/
```

---

## 🚨 Backup Best Practices

### ✅ DO:
- ✅ Test restore at least once a month
- ✅ Store backups in multiple locations (local + cloud)
- ✅ Monitor backup logs regularly
- ✅ Verify backup integrity
- ✅ Keep database credentials secure

### ❌ DON'T:
- ❌ Store backups in the same server as database (use cloud!)
- ❌ Ignore backup failures
- ❌ Delete backups manually
- ❌ Share database credentials
- ❌ Skip testing restores

---

## 🔒 Security

### Protect Backup Script:
```bash
# Restrict permissions (only owner can read/execute)
chmod 700 /home/melane/backups/daily_backup.sh

# Restrict backup directory
chmod 700 /home/melane/backups
```

### Encrypt Backups (Advanced):
```bash
# Encrypt before backup
mysqldump -u melane_user -p melane_kine | \
  gzip | \
  openssl enc -aes-256-cbc -salt -out backup_encrypted.sql.gz.enc

# Decrypt and restore
openssl enc -aes-256-cbc -d -in backup_encrypted.sql.gz.enc | \
  gunzip | \
  mysql -u melane_user -p melane_kine
```

---

## 📞 Troubleshooting

### Backup fails with "Access denied":
```bash
# Test database connection
mysql -u melane_user -p melane_kine

# If it doesn't work, update credentials in script
```

### Cron job not running:
```bash
# Check cron service
service cron status

# Start cron if stopped
service cron start

# Check system logs
grep CRON /var/log/syslog
```

### Out of disk space:
```bash
# Check disk usage
df -h

# Clean old logs
find /home/melane/backups/logs -name "*.log" -mtime +7 -delete

# Reduce retention periods in script
```

---

## ✅ Verification Checklist

After setup, verify:
- [ ] Script has correct database credentials
- [ ] Script is executable (chmod +x)
- [ ] Manual test run works
- [ ] Backup files created in correct directories
- [ ] Cron job is scheduled
- [ ] Logs are being created
- [ ] Test restore works
- [ ] Cloud backup configured (recommended)
- [ ] Email notifications work (optional)

---

## 🎯 Success!

Your database is now automatically backed up:
- **Daily:** Last 7 days
- **Weekly:** Last 4 weeks  
- **Monthly:** Last 12 months

Sleep better knowing your data is safe! 😴✅

