<?php
/**
 * Check Student API
 * Returns student information for parent registration
 */

require_once 'includes/functions.php';

header('Content-Type: application/json');

$username = trim($_GET['username'] ?? '');

if (empty($username)) {
    echo json_encode([
        'success' => false,
        'message' => 'Please enter a student username'
    ]);
    exit;
}

$pdo = getDB();

try {
    // Look up student with school and grade info
    $stmt = $pdo->prepare("
        SELECT 
            s.id,
            s.username,
            s.full_name,
            s.academy_reference,
            s.email,
            s.payment_status,
            g.name as grade_name,
            ar.academy_name as school_name
        FROM students s
        JOIN grades g ON s.grade_id = g.id
        JOIN academy_references ar ON s.academy_reference = ar.reference_code
        WHERE s.username = ?
    ");
    $stmt->execute([$username]);
    $student = $stmt->fetch();
    
    if ($student) {
        // Student found
        echo json_encode([
            'success' => true,
            'student' => [
                'id' => $student['id'],
                'username' => $student['username'],
                'full_name' => $student['full_name'],
                'academy_reference' => $student['academy_reference'],
                'school_name' => $student['school_name'],
                'grade_name' => $student['grade_name'],
                'email' => $student['email'],
                'payment_status' => $student['payment_status']
            ],
            'message' => 'Student found successfully'
        ]);
    } else {
        // Student not found
        echo json_encode([
            'success' => false,
            'message' => 'No student found with username "' . htmlspecialchars($username) . '". Please check the username and try again.'
        ]);
    }
    
} catch (PDOException $e) {
    error_log("Student lookup error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'An error occurred while checking the student. Please try again.'
    ]);
}

