#!/bin/bash
# Setup Tenant Backup Cron Jobs
# 
# This script helps configure automated backups for all tenants
# Run: bash cron/setup_backup_cron.sh

echo "============================================================"
echo "TENANT BACKUP CRON SETUP"
echo "============================================================"
echo ""

# Get script directory
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
PROJECT_ROOT="$(dirname "$SCRIPT_DIR")"

echo "Project root: $PROJECT_ROOT"
echo ""

# Check if crontab exists
if ! command -v crontab &> /dev/null; then
    echo "✗ crontab command not found"
    echo "  Please install cron or use cPanel Cron Jobs interface"
    exit 1
fi

echo "Suggested cron jobs:"
echo "------------------------------------------------------------"
echo ""

# Daily database backup (2 AM)
echo "# Daily tenant database backup (2 AM)"
echo "0 2 * * * /usr/bin/php $PROJECT_ROOT/cron/tenant_backups.php daily >> $PROJECT_ROOT/logs/backup_cron.log 2>&1"
echo ""

# Weekly file backup (Sunday 3 AM)
echo "# Weekly tenant file backup (Sunday 3 AM)"
echo "0 3 * * 0 /usr/bin/php $PROJECT_ROOT/cron/tenant_backups.php weekly >> $PROJECT_ROOT/logs/backup_cron.log 2>&1"
echo ""

# Monthly full backup (1st day, 4 AM)
echo "# Monthly full tenant backup (1st of month, 4 AM)"
echo "0 4 1 * * /usr/bin/php $PROJECT_ROOT/cron/tenant_backups.php monthly >> $PROJECT_ROOT/logs/backup_cron.log 2>&1"
echo ""

echo "------------------------------------------------------------"
echo ""
echo "To add these to cron:"
echo "1. Run: crontab -e"
echo "2. Paste the cron lines above"
echo "3. Save and exit"
echo ""
echo "Or in cPanel:"
echo "1. Go to Cron Jobs"
echo "2. Add each command with the specified schedule"
echo ""
echo "============================================================"

