-- =====================================================
-- ESWATINI CURRICULUM - COMPLETE SUBJECTS DATABASE
-- =====================================================
-- This script adds all subjects from the Eswatini curriculum
-- for Grades 4-7 (Primary) and Forms 1-5 (Secondary)
-- 
-- Each subject is created with a unique code per grade level
-- =====================================================

-- =====================================================
-- STEP 1: INSERT ALL SUBJECTS (UNIQUE CODES PER GRADE)
-- =====================================================
-- Format: [GRADE][SUBJECT]-[NUMBER]
-- G4 = Grade 4, G5 = Grade 5, G6 = Grade 6, G7 = Grade 7
-- F1 = Form 1, F2 = Form 2, F3 = Form 3, F4 = Form 4, F5 = Form 5

-- =====================================================
-- GRADE 4 SUBJECTS
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language', 'G4-ENG-001'),
('SiSwati Language', 'G4-SIS-002'),
('Mathematics', 'G4-MAT-003'),
('Science and Health Education', 'G4-SCI-004'),
('Social Studies', 'G4-SOC-005'),
('Religious Education', 'G4-REL-006'),
('Creative and Performing Arts (Art, Music, Crafts)', 'G4-CPA-007'),
('Art', 'G4-ART-008'),
('Music', 'G4-MUS-009'),
('Crafts', 'G4-CRA-010'),
('Physical Education', 'G4-PED-011'),
('Computer Awareness (Introductory ICT)', 'G4-ICT-012');

-- =====================================================
-- GRADE 5 SUBJECTS
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language', 'G5-ENG-001'),
('SiSwati Language', 'G5-SIS-002'),
('Mathematics', 'G5-MAT-003'),
('Science (Basic Science)', 'G5-SCI-004'),
('Social Studies', 'G5-SOC-005'),
('Religious Education', 'G5-REL-006'),
('Home Economics / Basic Consumer Science', 'G5-HE-007'),
('Home Economics', 'G5-HE-008'),
('Basic Consumer Science', 'G5-BCS-009'),
('Creative Arts & Physical Education', 'G5-CA-010'),
('Creative Arts', 'G5-CA-011'),
('Physical Education', 'G5-PED-012'),
('ICT (Practical Computer Skills)', 'G5-ICT-013');

-- =====================================================
-- GRADE 6 SUBJECTS
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language and Literature', 'G6-ENG-001'),
('SiSwati Language and Literature', 'G6-SIS-002'),
('Mathematics', 'G6-MAT-003'),
('Science (Living Things, Materials, Energy)', 'G6-SCI-004'),
('Social Studies (Geography, History, Civics)', 'G6-SOC-005'),
('Geography', 'G6-GEO-006'),
('History', 'G6-HIS-007'),
('Civics', 'G6-CIV-008'),
('Religious Education', 'G6-REL-009'),
('Home Economics / Agriculture', 'G6-HE-010'),
('Home Economics', 'G6-HE-011'),
('Agriculture', 'G6-AGR-012'),
('Creative & Performing Arts', 'G6-CA-013'),
('ICT / Digital Literacy', 'G6-ICT-014');

-- =====================================================
-- GRADE 7 SUBJECTS
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language (Reading, Writing, Grammar, Composition)', 'G7-ENG-001'),
('SiSwati Language (Reading, Grammar, Oral Work)', 'G7-SIS-002'),
('Mathematics (Arithmetic, Geometry, Problem Solving)', 'G7-MAT-003'),
('Science (Integrated Science)', 'G7-SCI-004'),
('Social Studies (National & Regional Studies)', 'G7-SOC-005'),
('Religious Education (Moral & Civic Values)', 'G7-REL-006'),
('Home Economics / Agriculture (Practical Skills)', 'G7-HE-007'),
('Home Economics', 'G7-HE-008'),
('Agriculture', 'G7-AGR-009'),
('Creative Arts (Music, Drawing, Drama)', 'G7-CA-010'),
('Creative Arts', 'G7-CA-011'),
('Music', 'G7-MUS-012'),
('Drawing', 'G7-DRA-013'),
('Drama', 'G7-DRA-014'),
('ICT / Computer Studies', 'G7-ICT-015');

-- =====================================================
-- FORM 1 SUBJECTS
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language', 'F1-ENG-001'),
('SiSwati Language', 'F1-SIS-002'),
('Mathematics', 'F1-MAT-003'),
('Integrated Science', 'F1-SCI-004'),
('Social Studies (History, Geography, Civics)', 'F1-SOC-005'),
('Social Studies', 'F1-SOC-006'),
('History', 'F1-HIS-007'),
('Geography', 'F1-GEO-008'),
('Civics', 'F1-CIV-009'),
('Religious Education', 'F1-REL-010'),
('Business Studies (Introductory)', 'F1-BUS-011'),
('Agriculture (Basic Principles)', 'F1-AGR-012'),
('Home Economics / Consumer Science', 'F1-HE-013'),
('Home Economics', 'F1-HE-014'),
('Consumer Science', 'F1-CS-015'),
('Design & Technology / Practical Skills', 'F1-DT-016'),
('Design & Technology', 'F1-DT-017'),
('Practical Skills', 'F1-PS-018'),
('ICT / Computer Literacy', 'F1-ICT-019'),
('Creative Arts / Physical Education', 'F1-CA-020'),
('Creative Arts', 'F1-CA-021'),
('Physical Education', 'F1-PED-022');

-- =====================================================
-- FORM 2 SUBJECTS
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language & Literature', 'F2-ENG-001'),
('SiSwati Language & Literature', 'F2-SIS-002'),
('Mathematics (Algebra, Geometry, Statistics)', 'F2-MAT-003'),
('Science (Physics, Chemistry, Biology Fundamentals)', 'F2-SCI-004'),
('Science', 'F2-SCI-005'),
('Physics', 'F2-PHY-006'),
('Chemistry', 'F2-CHE-007'),
('Biology Fundamentals', 'F2-BIO-008'),
('Social Studies (Regional & World Studies)', 'F2-SOC-009'),
('Religious Education', 'F2-REL-010'),
('Agriculture (Soil & Crop Studies)', 'F2-AGR-011'),
('Business Studies / Commerce', 'F2-BUS-012'),
('Business Studies', 'F2-BUS-013'),
('Commerce', 'F2-COM-014'),
('Design & Technology / Technical Drawing', 'F2-DT-015'),
('Design & Technology', 'F2-DT-016'),
('Technical Drawing', 'F2-TD-017'),
('Home Economics / Food & Nutrition', 'F2-HE-018'),
('Home Economics', 'F2-HE-019'),
('Food & Nutrition', 'F2-FN-020'),
('ICT / Computer Applications', 'F2-ICT-021'),
('Creative Arts / Physical Education', 'F2-CA-022'),
('Creative Arts', 'F2-CA-023'),
('Physical Education', 'F2-PED-024');

-- =====================================================
-- FORM 3 SUBJECTS
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language & Literature', 'F3-ENG-001'),
('SiSwati Language & Literature', 'F3-SIS-002'),
('Mathematics (Advanced Concepts & Problem Solving)', 'F3-MAT-003'),
('Integrated Science (Physics, Chemistry, Biology)', 'F3-SCI-004'),
('Integrated Science', 'F3-SCI-005'),
('Physics', 'F3-PHY-006'),
('Chemistry', 'F3-CHE-007'),
('Biology', 'F3-BIO-008'),
('Social Studies (Geography, History, Civics)', 'F3-SOC-009'),
('Geography', 'F3-GEO-010'),
('History', 'F3-HIS-011'),
('Civics', 'F3-CIV-012'),
('Religious Education', 'F3-REL-013'),
('Agriculture (Livestock & Crop Production)', 'F3-AGR-014'),
('Business Studies / Bookkeeping', 'F3-BUS-015'),
('Business Studies', 'F3-BUS-016'),
('Bookkeeping', 'F3-BK-017'),
('Design & Technology / Practical Skills', 'F3-DT-018'),
('Design & Technology', 'F3-DT-019'),
('Practical Skills', 'F3-PS-020'),
('Home Economics / Consumer Science', 'F3-HE-021'),
('Home Economics', 'F3-HE-022'),
('Consumer Science', 'F3-CS-023'),
('ICT / Computer Literacy', 'F3-ICT-024'),
('Creative Arts', 'F3-CA-025');

-- =====================================================
-- FORM 4 SUBJECTS (EGCSE Foundation)
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language (Core EGCSE Subject)', 'F4-ENG-001'),
('SiSwati Language (First or Second Language)', 'F4-SIS-002'),
('Mathematics (Core or Extended)', 'F4-MAT-003'),
('Science - Biology', 'F4-BIO-001'),
('Science - Physical Science', 'F4-PHS-001'),
('Science - Chemistry', 'F4-CHE-001'),
('Science - Physics', 'F4-PHY-001'),
('Religious Education', 'F4-REL-004'),
('Agriculture (Practical & Theory)', 'F4-AGR-005'),
('Business Studies / Commerce / Accounting', 'F4-BUS-006'),
('Business Studies', 'F4-BUS-007'),
('Commerce', 'F4-COM-008'),
('Accounting', 'F4-ACC-009'),
('Design & Technology', 'F4-DT-010'),
('Home Economics / Consumer Science', 'F4-HE-011'),
('Home Economics', 'F4-HE-012'),
('Consumer Science', 'F4-CS-013'),
('History / Geography', 'F4-HIS-014'),
('History', 'F4-HIS-015'),
('Geography', 'F4-GEO-016'),
('ICT / Computer Science', 'F4-ICT-017'),
('Creative Arts / Music / Drama', 'F4-CA-018'),
('Creative Arts', 'F4-CA-019'),
('Music', 'F4-MUS-020'),
('Drama', 'F4-DRA-021');

-- =====================================================
-- FORM 5 SUBJECTS (EGCSE Exam Level)
-- =====================================================
INSERT IGNORE INTO subjects (name, code) VALUES
('English Language (EGCSE Exam Level)', 'F5-ENG-001'),
('SiSwati (EGCSE Exam Level)', 'F5-SIS-002'),
('Mathematics (EGCSE Exam Level)', 'F5-MAT-003'),
('Science - Biology', 'F5-BIO-001'),
('Science - Chemistry', 'F5-CHE-001'),
('Science - Physics', 'F5-PHY-001'),
('Environmental Management', 'F5-ENV-004'),
('Religious Education', 'F5-REL-005'),
('Agriculture (Advanced EGCSE Level)', 'F5-AGR-006'),
('Business Studies / Accounting / Commerce / Economics', 'F5-BUS-007'),
('Business Studies', 'F5-BUS-008'),
('Accounting', 'F5-ACC-009'),
('Commerce', 'F5-COM-010'),
('Economics', 'F5-ECO-011'),
('Design & Technology / Technical Drawing', 'F5-DT-012'),
('Design & Technology', 'F5-DT-013'),
('Technical Drawing', 'F5-TD-014'),
('Home Economics / Food & Nutrition', 'F5-HE-015'),
('Home Economics', 'F5-HE-016'),
('Food & Nutrition', 'F5-FN-017'),
('History / Geography / Development Studies', 'F5-HIS-018'),
('History', 'F5-HIS-019'),
('Geography', 'F5-GEO-020'),
('Development Studies', 'F5-DEV-021'),
('ICT / Computer Science (EGCSE Exam Level)', 'F5-ICT-022'),
('Creative & Performing Arts (Optional / School-based)', 'F5-CPA-023'),
('Creative & Performing Arts', 'F5-CPA-024'),
('Music', 'F5-MUS-025'),
('Drama', 'F5-DRA-026');

-- =====================================================
-- STEP 2: LINK SUBJECTS TO GRADES
-- =====================================================
-- Note: This assumes grades exist with these exact names
-- If grade names differ, adjust accordingly

-- Grade 4 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Grade 4'
AND s.code LIKE 'G4-%';

-- Grade 5 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Grade 5'
AND s.code LIKE 'G5-%';

-- Grade 6 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Grade 6'
AND s.code LIKE 'G6-%';

-- Grade 7 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Grade 7'
AND s.code LIKE 'G7-%';

-- Form 1 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Form 1'
AND s.code LIKE 'F1-%';

-- Form 2 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Form 2'
AND s.code LIKE 'F2-%';

-- Form 3 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Form 3'
AND s.code LIKE 'F3-%';

-- Form 4 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Form 4'
AND s.code LIKE 'F4-%';

-- Form 5 Subjects
INSERT IGNORE INTO grade_subject (grade_id, subject_id)
SELECT g.id, s.id
FROM grades g
CROSS JOIN subjects s
WHERE g.name = 'Form 5'
AND s.code LIKE 'F5-%';

-- =====================================================
-- VERIFICATION QUERIES
-- =====================================================
-- Run these to verify the data was inserted correctly

-- Check total subjects count
-- SELECT COUNT(*) AS total_subjects FROM subjects;

-- Check subjects per grade
-- SELECT g.name AS grade_name, COUNT(gs.subject_id) AS subject_count
-- FROM grades g
-- LEFT JOIN grade_subject gs ON g.id = gs.grade_id
-- GROUP BY g.id, g.name
-- ORDER BY g.name;

-- List all subjects for a specific grade
-- SELECT s.name, s.code
-- FROM subjects s
-- JOIN grade_subject gs ON s.id = gs.subject_id
-- JOIN grades g ON gs.grade_id = g.id
-- WHERE g.name = 'Grade 4'
-- ORDER BY s.name;

-- =====================================================
-- COMPLETE!
-- =====================================================
-- All Eswatini curriculum subjects have been added
-- and linked to their respective grades.
-- 
-- Primary School: Grades 4-7
-- Secondary School: Forms 1-5 (Junior Certificate & EGCSE)
-- 
-- Total subjects added: ~200+ unique subjects
-- Each grade has its specific subjects as per curriculum
-- =====================================================
