-- Create payments table for MTN MoMo integration
-- This table stores payment requests and their status

CREATE TABLE IF NOT EXISTS payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    student_id INT NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    currency VARCHAR(8) NOT NULL DEFAULT 'SZL',
    reference_id VARCHAR(64) UNIQUE NOT NULL,  -- UUID for MTN MoMo API
    external_id VARCHAR(64) NOT NULL,         -- Business reference (SK + timestamp)
    msisdn VARCHAR(32) NOT NULL,              -- Phone number
    status VARCHAR(32) NOT NULL DEFAULT 'PENDING',  -- PENDING, SUCCESSFUL, FAILED, CANCELLED
    momo_status VARCHAR(50) NULL,             -- Raw status from MTN MoMo
    raw_response TEXT NULL,                   -- Full response from MTN MoMo
    error_message TEXT NULL,                  -- Error details if failed
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    KEY idx_payments_student_id (student_id),
    KEY idx_payments_reference_id (reference_id),
    KEY idx_payments_external_id (external_id),
    KEY idx_payments_status (status),
    KEY idx_payments_created_at (created_at),
    
    CONSTRAINT fk_payments_student FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add payment-related columns to students table if they don't exist
ALTER TABLE students 
ADD COLUMN IF NOT EXISTS payment_status VARCHAR(32) DEFAULT 'UNPAID',
ADD COLUMN IF NOT EXISTS payment_date TIMESTAMP NULL,
ADD COLUMN IF NOT EXISTS phone VARCHAR(32) NULL;

-- Create index on payment_status for faster queries
CREATE INDEX IF NOT EXISTS idx_students_payment_status ON students(payment_status);
CREATE INDEX IF NOT EXISTS idx_students_payment_date ON students(payment_date);
