-- Migration script to add soft deletion fields to students table
-- Run this script in your database to enable the soft deletion system

-- Add soft deletion fields to students table
ALTER TABLE students 
ADD COLUMN deleted_at DATETIME NULL,
ADD COLUMN permanent_delete_date DATETIME NULL,
ADD COLUMN status ENUM('active', 'suspended') DEFAULT 'active';

-- Add index for better performance on status queries
CREATE INDEX idx_students_status ON students(status);
CREATE INDEX idx_students_deleted_at ON students(deleted_at);
CREATE INDEX idx_students_permanent_delete_date ON students(permanent_delete_date);

-- Update existing students to have 'active' status
UPDATE students SET status = 'active' WHERE status IS NULL;

-- Show the updated table structure
DESCRIBE students;
