-- Super Admin Settings Table
-- Stores global default settings that apply to all tenants
CREATE TABLE IF NOT EXISTS `super_admin_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Insert default SMS gateway settings (disabled by default)
INSERT INTO `super_admin_settings` (`setting_key`, `setting_value`) VALUES
('default_sms_enabled', '0'),
('default_sms_provider', 'africastalking'),
('default_at_username', 'sandbox'),
('default_at_api_key', ''),
('default_at_sender_id', 'SKOLO'),
('default_twilio_account_sid', ''),
('default_twilio_auth_token', ''),
('default_twilio_from_number', '')
ON DUPLICATE KEY UPDATE setting_value = setting_value;

