-- =====================================================
-- TENANT FILES TABLE - ROLLBACK SCRIPT
-- =====================================================
-- Purpose: Undo the create_tenant_files_table migration
-- WARNING: This will delete all data in tenant_files table!
-- Date: 2025-01-30
-- =====================================================

-- =====================================================
-- CONFIRMATION CHECK
-- =====================================================

SELECT '!!! WARNING !!!' AS notice;
SELECT 'This script will DELETE the tenant_files table and all related data!' AS warning;
SELECT 'Make sure you have a backup before proceeding!' AS reminder;
SELECT 'Continue only if you are certain you want to rollback.' AS confirmation;

-- Pause for confirmation (uncomment to require manual confirmation)
-- SELECT 'Type YES to continue' AS prompt;
-- SET @continue = 'NO';
-- -- User must set @continue = 'YES' manually

-- =====================================================
-- STEP 1: BACKUP CURRENT DATA
-- =====================================================

-- Create backup of current data
CREATE TABLE IF NOT EXISTS tenant_files_rollback_backup AS 
SELECT * FROM tenant_files;

CREATE TABLE IF NOT EXISTS tenant_file_access_log_rollback_backup AS
SELECT * FROM tenant_file_access_log;

CREATE TABLE IF NOT EXISTS tenant_file_versions_rollback_backup AS
SELECT * FROM tenant_file_versions;

SELECT 'Data backed up to rollback_backup tables' AS status;

-- =====================================================
-- STEP 2: DROP VIEWS
-- =====================================================

DROP VIEW IF EXISTS v_active_tenant_files;
DROP VIEW IF EXISTS v_tenant_file_stats;

SELECT 'Views dropped' AS status;

-- =====================================================
-- STEP 3: DROP TRIGGERS
-- =====================================================

DROP TRIGGER IF EXISTS before_tenant_file_access_insert;

SELECT 'Triggers dropped' AS status;

-- =====================================================
-- STEP 4: DROP RELATED TABLES
-- =====================================================

DROP TABLE IF EXISTS tenant_file_versions;
DROP TABLE IF EXISTS tenant_file_access_log;

SELECT 'Related tables dropped' AS status;

-- =====================================================
-- STEP 5: DROP MAIN TABLE
-- =====================================================

DROP TABLE IF EXISTS tenant_files;

SELECT 'Main table dropped' AS status;

-- =====================================================
-- STEP 6: RESTORE FROM BACKUP (IF EXISTS)
-- =====================================================

-- Restore from migration backup if it exists
CREATE TABLE IF NOT EXISTS tenant_files AS
SELECT * FROM tenant_files_backup_20250130
WHERE EXISTS (
    SELECT 1 FROM information_schema.TABLES
    WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'tenant_files_backup_20250130'
);

SELECT CASE 
    WHEN EXISTS (
        SELECT 1 FROM information_schema.TABLES
        WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'tenant_files_backup_20250130'
    ) THEN 'Data restored from backup'
    ELSE 'No backup found to restore'
END AS restoration_status;

-- =====================================================
-- STEP 7: CLEANUP BACKUP TABLES (OPTIONAL)
-- =====================================================

-- Uncomment to remove backup tables after successful rollback
-- DROP TABLE IF EXISTS tenant_files_backup_20250130;
-- DROP TABLE IF EXISTS tenant_files_rollback_backup;
-- DROP TABLE IF EXISTS tenant_file_access_log_rollback_backup;
-- DROP TABLE IF EXISTS tenant_file_versions_rollback_backup;

-- =====================================================
-- VERIFICATION
-- =====================================================

-- Check what's left
SELECT 
    TABLE_NAME,
    TABLE_ROWS
FROM information_schema.TABLES
WHERE TABLE_SCHEMA = DATABASE()
AND TABLE_NAME LIKE '%tenant_file%'
ORDER BY TABLE_NAME;

-- =====================================================
-- ROLLBACK COMPLETE
-- =====================================================

SELECT '=== ROLLBACK COMPLETE ===' AS status;
SELECT 'tenant_files table and related objects have been removed' AS message;
SELECT 'Backup tables are preserved for safety' AS note;
SELECT 'Drop backup tables manually if no longer needed' AS cleanup;

-- =====================================================
-- TO CLEANUP BACKUPS MANUALLY
-- =====================================================

-- Run these commands after verifying rollback was successful:
-- DROP TABLE IF EXISTS tenant_files_backup_20250130;
-- DROP TABLE IF EXISTS tenant_files_rollback_backup;
-- DROP TABLE IF EXISTS tenant_file_access_log_rollback_backup;
-- DROP TABLE IF EXISTS tenant_file_versions_rollback_backup;

-- =====================================================
-- END OF ROLLBACK
-- =====================================================

