<?php
/**
 * Favicon Helper
 * Generates favicon HTML tags using school logo or default image
 */

/**
 * Get favicon HTML for current school
 * Returns HTML link tags for favicon
 */
function getFaviconHTML($academy_reference = null) {
    try {
        $pdo = getDB();
        
        // Get academy reference from context if not provided
        if (!$academy_reference && function_exists('getCurrentSchool')) {
            try {
                $academy_reference = getCurrentSchool();
            } catch (Exception $e) {
                // Use default if no school context
                $academy_reference = null;
            }
        }
        
        $favicon_url = '../images/img-melanesys-logo.svg'; // Default
        
        // Try to get school logo
        if ($academy_reference) {
            $stmt = $pdo->prepare("
                SELECT setting_value 
                FROM tenant_settings 
                WHERE academy_reference = ? AND setting_key = 'logo_url'
            ");
            $stmt->execute([$academy_reference]);
            $logo = $stmt->fetchColumn();
            
            if ($logo) {
                $favicon_url = $logo;
            }
        }
        
        // Generate HTML
        $html = '    <link rel="icon" type="image/svg+xml" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        $html .= '    <link rel="icon" type="image/png" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        $html .= '    <link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        
        return $html;
        
    } catch (Exception $e) {
        // Return default on error
        return '    <link rel="icon" type="image/svg+xml" href="../images/img-melanesys-logo.svg">' . "\n";
    }
}

/**
 * Get just the favicon URL (for use in img tags, etc.)
 */
function getFaviconURL($academy_reference = null) {
    try {
        $pdo = getDB();
        
        if (!$academy_reference && function_exists('getCurrentSchool')) {
            try {
                $academy_reference = getCurrentSchool();
            } catch (Exception $e) {
                return '../images/img-melanesys-logo.svg';
            }
        }
        
        if ($academy_reference) {
            $stmt = $pdo->prepare("
                SELECT setting_value 
                FROM tenant_settings 
                WHERE academy_reference = ? AND setting_key = 'logo_url'
            ");
            $stmt->execute([$academy_reference]);
            $logo = $stmt->fetchColumn();
            
            if ($logo) {
                return $logo;
            }
        }
        
        return '../images/img-melanesys-logo.svg';
        
    } catch (Exception $e) {
        return '../images/img-melanesys-logo.svg';
    }
}

/**
 * Echo favicon HTML (convenience function)
 */
function echoFavicon($academy_reference = null) {
    echo getFaviconHTML($academy_reference);
}

