<?php
/**
 * Universal Logout Handler
 * Handles logout for both admin and parent users
 */

require_once 'includes/functions.php';

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Determine user type and logout accordingly
$is_parent = isset($_GET['parent']) || isset($_SESSION['parent_logged_in']);
$is_admin = isset($_SESSION['admin_logged_in']) || isset($_SESSION['is_super_admin']);

// Parent Logout
if ($is_parent) {
    // Log parent logout activity
    if (isset($_SESSION['parent_id'])) {
        require_once 'includes/parent_functions.php';
        logParentActivity($_SESSION['parent_id'], 'LOGOUT', 'Logged out from parent portal');
    }
    
    // Clear parent session variables
    unset($_SESSION['parent_logged_in']);
    unset($_SESSION['parent_id']);
    unset($_SESSION['parent_name']);
    unset($_SESSION['parent_email']);
    
    // Clear remember me cookie if exists
    if (isset($_COOKIE['parent_remember'])) {
        setcookie('parent_remember', '', time() - 3600, '/');
    }
    
    // Redirect to parent login
    header('Location: parent_login.php');
    exit;
}

// Admin Logout
if ($is_admin) {
    require_once 'includes/school_context.php';
    
    // Log admin logout activity
    if (function_exists('logSchoolActivity')) {
        logSchoolActivity('LOGOUT', 'Admin logged out');
    }
    
    // Clear school context
    if (function_exists('clearSchoolContext')) {
        clearSchoolContext();
    }
    
    // Clear admin session variables
    unset($_SESSION['admin_logged_in']);
    unset($_SESSION['admin_id']);
    unset($_SESSION['admin_username']);
    unset($_SESSION['admin_email']);
    unset($_SESSION['is_super_admin']);
    unset($_SESSION['admin_academy_reference']);
    unset($_SESSION['academy_reference']);
    unset($_SESSION['academy_name']);
    unset($_SESSION['academy_id']);
    
    // Redirect to admin login
    header('Location: admin/login.php');
    exit;
}

// Default: Clear all session data and redirect to home
session_destroy();
header('Location: index.php');
exit;

