<?php
/**
 * Test .htaccess Generator
 * 
 * Run: php test_htaccess_generator.php
 * Or visit: http://your-domain/test_htaccess_generator.php
 */

require_once 'templates/htaccess_templates.php';

echo "Testing .htaccess Generator\n";
echo str_repeat("=", 60) . "\n\n";

// Test 1: Generate for uploads
echo "1. UPLOADS .htaccess:\n";
echo str_repeat("-", 60) . "\n";
echo HtaccessGenerator::forUploads(['pdf', 'jpg', 'png']);
echo "\n\n";

// Test 2: Generate for backups
echo "2. BACKUPS .htaccess:\n";
echo str_repeat("-", 60) . "\n";
echo HtaccessGenerator::forBackups();
echo "\n\n";

// Test 3: Generate for logs
echo "3. LOGS .htaccess:\n";
echo str_repeat("-", 60) . "\n";
echo HtaccessGenerator::forLogs();
echo "\n\n";

// Test 4: Generate for temp
echo "4. TEMP .htaccess:\n";
echo str_repeat("-", 60) . "\n";
echo HtaccessGenerator::forTemp();
echo "\n\n";

// Test 5: Generate all templates
echo "5. ALL TEMPLATES:\n";
echo str_repeat("-", 60) . "\n";
$all = HtaccessGenerator::getAllTemplates();
echo "Generated " . count($all) . " templates:\n";
foreach ($all as $dir => $content) {
    echo "  ✓ {$dir}\n";
}
echo "\n";

// Test 6: Write to test directory
echo "6. WRITE TO DIRECTORY TEST:\n";
echo str_repeat("-", 60) . "\n";

$testDir = __DIR__ . '/tenants/test_htaccess_' . time();
mkdir($testDir, 0755, true);

$result = HtaccessGenerator::writeAllToDirectory($testDir);

if ($result['success']) {
    echo "✓ Success! Created {$result['created']} .htaccess files\n";
    echo "  Test directory: {$testDir}\n\n";
    
    // Show files created
    echo "Files created:\n";
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($testDir, RecursiveDirectoryIterator::SKIP_DOTS)
    );
    
    foreach ($iterator as $file) {
        if ($file->getFilename() === '.htaccess') {
            $relative = str_replace($testDir, '', $file->getPathname());
            echo "  ✓ {$relative}\n";
        }
    }
    
    echo "\n✓ Test directory created successfully!\n";
    echo "  Location: {$testDir}\n";
    echo "  You can inspect the .htaccess files there.\n";
    echo "  Delete when done: rm -rf {$testDir}\n";
} else {
    echo "✗ Failed to create files\n";
}

echo "\n" . str_repeat("=", 60) . "\n";
echo "Test complete!\n";

