<?php
/**
 * Test Storage API Endpoints
 * 
 * Run: php test_storage_api.php
 */

require_once 'config.php';

// Simulate session
$_SESSION['user_id'] = 1;
$_SESSION['role'] = 'super_admin';
$_SESSION['academy_reference'] = 'soshigh_demo';

echo "Testing Storage API Endpoints\n";
echo str_repeat("=", 60) . "\n\n";

// Test 1: Get tenant storage
echo "1. GET /api/storage/tenant/soshigh_demo\n";
echo str_repeat("-", 60) . "\n";

$_GET['id'] = 'soshigh_demo';
ob_start();
include 'api/storage/tenant.php';
$response = ob_get_clean();
echo $response . "\n\n";

// Test 2: Get storage usage
echo "2. GET /api/storage/usage/soshigh_demo\n";
echo str_repeat("-", 60) . "\n";

$_GET['tenant_id'] = 'soshigh_demo';
ob_start();
include 'api/storage/usage.php';
$response = ob_get_clean();
echo $response . "\n\n";

echo str_repeat("=", 60) . "\n";
echo "API Tests Complete!\n";

