<?php
/**
 * Test URL Helper - Delete this file after testing
 */
require_once 'includes/url_helper.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>URL Helper Test</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { background: white; padding: 20px; border-radius: 8px; max-width: 900px; margin: 0 auto; }
        h1 { color: #333; }
        .success { color: green; font-weight: bold; }
        .info { background: #e3f2fd; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .debug { background: #fff3cd; padding: 15px; border-radius: 5px; margin: 10px 0; font-family: monospace; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        table td { padding: 8px; border: 1px solid #ddd; }
        table td:first-child { background: #f5f5f5; font-weight: bold; width: 40%; }
        .url { color: blue; word-break: break-all; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 URL Helper Test</h1>
        
        <div class="info">
            <h2>📍 Current Request Information:</h2>
            <table>
                <tr>
                    <td>Is Localhost</td>
                    <td><?= isLocalhost() ? '<span class="success">✅ YES</span>' : '❌ NO' ?></td>
                </tr>
                <tr>
                    <td>Server Name</td>
                    <td><?= htmlspecialchars($_SERVER['SERVER_NAME']) ?></td>
                </tr>
                <tr>
                    <td>HTTP Host</td>
                    <td><?= htmlspecialchars($_SERVER['HTTP_HOST']) ?></td>
                </tr>
                <tr>
                    <td>Request URI</td>
                    <td class="url"><?= htmlspecialchars($_SERVER['REQUEST_URI']) ?></td>
                </tr>
                <tr>
                    <td>Script Name</td>
                    <td class="url"><?= htmlspecialchars($_SERVER['SCRIPT_NAME']) ?></td>
                </tr>
                <tr>
                    <td>Script Dir (dirname)</td>
                    <td class="url"><?= htmlspecialchars(dirname($_SERVER['SCRIPT_NAME'])) ?></td>
                </tr>
            </table>
        </div>

        <div class="info">
            <h2>🌐 Detected Base URL:</h2>
            <p class="url" style="font-size: 18px; font-weight: bold;"><?= htmlspecialchars(getBaseURL()) ?></p>
        </div>

        <div class="info">
            <h2>🔗 Generated URLs:</h2>
            <table>
                <tr>
                    <td>verify_registration.php</td>
                    <td class="url"><?= htmlspecialchars(generateURL('verify_registration.php')) ?></td>
                </tr>
                <tr>
                    <td>payment_for_application.php</td>
                    <td class="url"><?= htmlspecialchars(generateURL('payment_for_application.php')) ?></td>
                </tr>
                <tr>
                    <td>register_student.php</td>
                    <td class="url"><?= htmlspecialchars(generateURL('register_student.php')) ?></td>
                </tr>
            </table>
        </div>

        <div class="info">
            <h2>📧 Example Verification Link:</h2>
            <?php $test_token = "abc123def456"; ?>
            <p class="url"><?= htmlspecialchars(generateURL('verify_registration.php') . "?token=" . urlencode($test_token)) ?></p>
        </div>

        <div class="debug">
            <h3>Expected Results:</h3>
            <p>✅ Base URL should be: <strong>https://test.melanegroup.com/Multi-Tanent</strong></p>
            <p>✅ Verification link should be: <strong>https://test.melanegroup.com/Multi-Tanent/verify_registration.php?token=...</strong></p>
            <p>❌ Should NOT include: /test/ or /kine/ or /Skolo-Kine/ in the base URL</p>
        </div>

        <p style="margin-top: 20px; color: red; font-weight: bold;">
            ⚠️ Delete this file after testing: test_url_helper.php
        </p>
    </div>
</body>
</html>

