<?php
require_once __DIR__ . '/../includes/functions.php';

echo "Adding price column to subjects table...\n";

try {
    $pdo = getDB();
    
    // Check if price column exists
    $stmt = $pdo->query("DESCRIBE subjects");
    $columns = array_column($stmt->fetchAll(), 'Field');
    
    if (!in_array('price', $columns)) {
        // Add price column
        $pdo->exec("ALTER TABLE subjects ADD COLUMN price DECIMAL(10,2) DEFAULT 0.30");
        echo "✅ Added price column to subjects table\n";
        
        // Set default prices for existing subjects
        $pdo->exec("UPDATE subjects SET price = " . SUBJECT_PRICE);
        echo "✅ Set default prices for existing subjects\n";
    } else {
        echo "✅ Price column already exists\n";
    }
    
    // Verify the column was added
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM subjects WHERE price IS NOT NULL");
    $count = $stmt->fetch()['count'];
    echo "✅ $count subjects have prices set\n";
    
    echo "\n🎉 Subject price column setup complete!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
